/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.model.jam;

import com.intellij.ide.presentation.Presentation;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.annotations.JamPsiValidity;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.PsiType;
import com.intellij.psi.targets.AliasingPsiTarget;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.seam.model.CommonSeamComponent;
import com.intellij.seam.model.CommonSeamFactoryComponent;
import com.intellij.seam.model.SeamComponentScope;
import com.intellij.semantic.SemKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="Seam Factory")
public abstract class SeamJamFactory
extends CommonModelElement.PsiBase
implements JamElement,
CommonSeamComponent,
CommonSeamFactoryComponent {
    public static final JamStringAttributeMeta.Single<String> NAME_VALUE_META = JamAttributeMeta.singleString((String)"value");
    public static final JamAnnotationMeta ANNOTATION_META = new JamAnnotationMeta("org.jboss.seam.annotations.Factory").addAttribute(NAME_VALUE_META);
    public static final SemKey<SeamJamFactory> JAM_KEY = JamService.JAM_ALIASING_ELEMENT_KEY.subKey("SeamJamFactory", new SemKey[0]);
    public static final JamMemberMeta<PsiMethod, SeamJamFactory> META = new JamMethodMeta(null, SeamJamFactory.class, JAM_KEY).addPomTargetProducer((seamJamFactory, consumer) -> consumer.consume((Object)seamJamFactory.getPsiTarget())).addAnnotation(ANNOTATION_META);

    protected JamStringAttributeElement<String> getNamedStringAttributeElement() {
        return (JamStringAttributeElement)ANNOTATION_META.getAttribute((PsiModifierListOwner)this.getPsiElement(), NAME_VALUE_META);
    }

    public PsiTarget getPsiTarget() {
        JamStringAttributeElement<String> namedAttributeValue = this.getNamedStringAttributeElement();
        if (StringUtil.isEmptyOrSpaces((String)namedAttributeValue.getStringValue())) {
            return this.getAliasingPsiTarget();
        }
        return new JamPomTarget((JamElement)this, namedAttributeValue);
    }

    private PsiTarget getAliasingPsiTarget() {
        return new AliasingPsiTarget((PsiNamedElement)this.getPsiElement()){

            public String getNameAlias(@Nullable String delegatePsiTargetName) {
                return PropertyUtil.getPropertyName((String)delegatePsiTargetName);
            }
        };
    }

    public PsiElement getIdentifyingPsiElement() {
        return PomService.convertToPsi((Project)this.getPsiElement().getProject(), (PomTarget)this.getPsiTarget());
    }

    @JamPsiConnector
    @NotNull
    public abstract PsiMethod getPsiElement();

    @JamPsiValidity
    public abstract boolean isValid();

    @Override
    @Nullable
    public String getFactoryName() {
        String nameValue = this.getNamedStringAttributeElement().getStringValue();
        return StringUtil.isEmptyOrSpaces((String)nameValue) ? PropertyUtil.getPropertyName((PsiMethod)this.getPsiElement()) : nameValue;
    }

    public PsiAnnotation getIdentifyingAnnotation() {
        return ANNOTATION_META.getAnnotation((PsiModifierListOwner)this.getPsiElement());
    }

    @Nullable
    private String getVoidMethodFactoryName() {
        PsiMethod method = this.getPsiElement();
        if (SeamJamFactory.hasGetterName(method)) {
            return PropertyUtil.getPropertyNameByGetter((PsiMethod)method);
        }
        return null;
    }

    private static boolean hasGetterName(@NotNull PsiMethod method) {
        String[] prefixes;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/seam/model/jam/SeamJamFactory", "hasGetterName"));
        }
        if (method.isConstructor()) {
            return false;
        }
        String methodName = method.getName();
        for (String prefix : prefixes = new String[]{"get", "is"}) {
            if (!methodName.startsWith(prefix) || methodName.length() <= prefix.length() || !Character.isLowerCase(methodName.charAt(prefix.length())) || methodName.length() != prefix.length() + 1 && !Character.isLowerCase(methodName.charAt(prefix.length() + 1))) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public SeamComponentScope getFactoryScope() {
        return (SeamComponentScope)((Object)AnnotationModelUtil.getEnumValue((PsiAnnotation)this.getIdentifyingAnnotation(), (String)"scope", SeamComponentScope.class).getValue());
    }

    @Override
    @Nullable
    public PsiType getFactoryType() {
        PsiMethod method = this.getPsiElement();
        return method.getReturnType();
    }
}

