/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.diagram.beans;

import com.intellij.diagram.DiagramEdgeBase;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramRelationshipInfoAdapter;
import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.spring.webflow.diagram.WebflowDiagramPresentationConstants;
import com.intellij.spring.webflow.diagram.beans.WebflowEdgeType;
import com.intellij.spring.webflow.diagram.beans.wrappers.WebflowElementWrapper;
import com.intellij.util.xml.DomElement;
import java.awt.Color;
import java.awt.Shape;
import org.jetbrains.annotations.Nullable;

public class WebflowDiagramEdge
extends DiagramEdgeBase<WebflowElementWrapper> {
    private final DomElement myDefiningElement;
    private final WebflowEdgeType myEdgeType;

    public WebflowDiagramEdge(DiagramNode<WebflowElementWrapper> source, DiagramNode<WebflowElementWrapper> target, @Nullable DomElement definingElement, WebflowEdgeType edgeType, String customInfo) {
        super(source, target, WebflowDiagramEdge.getInfo(edgeType, customInfo));
        this.myDefiningElement = definingElement;
        this.myEdgeType = edgeType;
    }

    @Nullable
    public DomElement getDefiningElement() {
        return this.myDefiningElement;
    }

    public WebflowEdgeType getEdgeType() {
        return this.myEdgeType;
    }

    private static DiagramRelationshipInfo getInfo(final WebflowEdgeType type, @Nullable String label) {
        return new DiagramRelationshipInfoAdapter(null, WebflowDiagramEdge.getLineType(type), label){

            public Shape getStartArrow() {
                if (type == WebflowEdgeType.PARENT) {
                    return DELTA;
                }
                if (type == WebflowEdgeType.EVENT) {
                    return NONE;
                }
                return STANDARD;
            }

            public Shape getEndArrow() {
                if (type == WebflowEdgeType.EVENT) {
                    return DIAMOND;
                }
                return super.getEndArrow();
            }

            public Color getLabelColor() {
                if (type == WebflowEdgeType.GLOBAL_TO) {
                    return WebflowDiagramPresentationConstants.EDGE_GLOBAL_TRANSITIONS_COLOR;
                }
                if (type == WebflowEdgeType.PARENT) {
                    return WebflowDiagramPresentationConstants.EDGE_PARENT_COLOR;
                }
                if (type == WebflowEdgeType.ON_EXCEPTION) {
                    return WebflowDiagramPresentationConstants.EDGE_EXCEPTION_COLOR;
                }
                if (type == WebflowEdgeType.SUBFLOW) {
                    return WebflowDiagramPresentationConstants.EDGE_SUBFLOW_COLOR;
                }
                return super.getLabelColor();
            }
        };
    }

    private static DiagramLineType getLineType(WebflowEdgeType type) {
        switch (type) {
            case ELSE: {
                return DiagramLineType.DASHED;
            }
            case SUBFLOW: {
                return DiagramLineType.DOTTED;
            }
        }
        return DiagramLineType.SOLID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebflowDiagramEdge)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebflowDiagramEdge that = (WebflowDiagramEdge)((Object)o);
        return this.myEdgeType == that.myEdgeType;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myEdgeType.hashCode();
        return result;
    }
}

