/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.diagram.managers;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.webflow.diagram.WebflowDiagramPresentationConstants;
import com.intellij.spring.webflow.diagram.beans.wrappers.WebflowDomElementWrapper;
import com.intellij.spring.webflow.diagram.beans.wrappers.WebflowElementWrapper;
import com.intellij.spring.webflow.diagram.beans.wrappers.WebflowFlowWrapper;
import com.intellij.spring.webflow.diagram.beans.wrappers.WebflowModuleWrapper;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.spring.webflow.model.xml.ActionsOwner;
import com.intellij.spring.webflow.model.xml.Attribute;
import com.intellij.spring.webflow.model.xml.AttributesOwner;
import com.intellij.spring.webflow.model.xml.DecisionState;
import com.intellij.spring.webflow.model.xml.EndState;
import com.intellij.spring.webflow.model.xml.Evaluate;
import com.intellij.spring.webflow.model.xml.EvaluatesOwner;
import com.intellij.spring.webflow.model.xml.ExceptionHandler;
import com.intellij.spring.webflow.model.xml.ExceptionHandlerOwner;
import com.intellij.spring.webflow.model.xml.GlobalTransitions;
import com.intellij.spring.webflow.model.xml.If;
import com.intellij.spring.webflow.model.xml.Input;
import com.intellij.spring.webflow.model.xml.OnEnd;
import com.intellij.spring.webflow.model.xml.OnEntry;
import com.intellij.spring.webflow.model.xml.OnExit;
import com.intellij.spring.webflow.model.xml.OnRender;
import com.intellij.spring.webflow.model.xml.OnStart;
import com.intellij.spring.webflow.model.xml.Output;
import com.intellij.spring.webflow.model.xml.RendersOwner;
import com.intellij.spring.webflow.model.xml.Set;
import com.intellij.spring.webflow.model.xml.SetOwner;
import com.intellij.spring.webflow.model.xml.SetsOwner;
import com.intellij.spring.webflow.model.xml.SubflowState;
import com.intellij.spring.webflow.model.xml.Var;
import com.intellij.spring.webflow.model.xml.ViewState;
import com.intellij.spring.webflow.util.WebflowUtil;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebflowDiagramElementManager
extends AbstractDiagramElementManager<WebflowElementWrapper> {
    public WebflowElementWrapper findInDataContext(DataContext context) {
        WebflowDomModelManager domModelManager;
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        if (psiFile instanceof XmlFile && !(psiFile instanceof JspFile) && (domModelManager = WebflowDomModelManager.getInstance(psiFile.getProject())).isWebflow((XmlFile)psiFile) && domModelManager.getWebflowModel((XmlFile)psiFile) != null) {
            return new WebflowFlowWrapper((XmlFile)psiFile);
        }
        Module module = (Module)LangDataKeys.MODULE.getData(context);
        if (WebflowUtil.isWebFlowAvailable(module)) {
            return new WebflowModuleWrapper(module);
        }
        return null;
    }

    public boolean isAcceptableAsNode(Object element) {
        return element instanceof WebflowElementWrapper;
    }

    public String getElementTitle(WebflowElementWrapper element) {
        return element.isValid() ? element.getName() : "<invalid>";
    }

    public SimpleColoredText getItemName(Object element, DiagramState presentation) {
        if (element instanceof WebflowDomElementWrapper) {
            WebflowDomElementWrapper webflowElementWrapper = (WebflowDomElementWrapper)element;
            if (!webflowElementWrapper.isValid()) {
                return WebflowDiagramPresentationConstants.INVALID_SIMPLE_COLORED_TEXT;
            }
            SimpleColoredText customText = WebflowDiagramElementManager.createCustomNodePresentableName(webflowElementWrapper);
            if (customText != null) {
                return customText;
            }
            boolean isStartAction = webflowElementWrapper.getUserData(WebflowDomElementWrapper.IS_START_STATE) == Boolean.TRUE;
            return new SimpleColoredText(webflowElementWrapper.getName(), isStartAction ? SimpleTextAttributes.LINK_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        if (element instanceof DomElement) {
            DomElement domElement = (DomElement)element;
            String name = WebflowDiagramElementManager.getDomElementPresentableName(domElement);
            return new SimpleColoredText(name, DEFAULT_TEXT_ATTR);
        }
        if (element instanceof SimpleColoredText) {
            return (SimpleColoredText)element;
        }
        return new SimpleColoredText("???" + element + "???", SimpleTextAttributes.ERROR_ATTRIBUTES);
    }

    @Nullable
    private static SimpleColoredText createCustomNodePresentableName(WebflowDomElementWrapper wrapper) {
        DomElement domElement = wrapper.getElement();
        if (domElement instanceof OnEntry || domElement instanceof OnExit || domElement instanceof OnRender) {
            return new SimpleColoredText(domElement.getPresentation().getTypeName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        if (domElement instanceof OnStart || domElement instanceof OnEnd) {
            return new SimpleColoredText(domElement.getPresentation().getTypeName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        if (domElement instanceof GlobalTransitions) {
            return new SimpleColoredText(domElement.getPresentation().getTypeName(), SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        }
        return null;
    }

    @NotNull
    private static String getDomElementPresentableName(DomElement domElement) {
        if (!domElement.isValid()) {
            if ("<invalid>" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/diagram/managers/WebflowDiagramElementManager", "getDomElementPresentableName"));
            }
            return "<invalid>";
        }
        if (domElement instanceof If) {
            If anIf = (If)domElement;
            String string = anIf.getTest().getRawText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/diagram/managers/WebflowDiagramElementManager", "getDomElementPresentableName"));
            }
            return string;
        }
        if (domElement instanceof ExceptionHandler) {
            String string = ((ExceptionHandler)domElement).getBean().getRawText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/diagram/managers/WebflowDiagramElementManager", "getDomElementPresentableName"));
            }
            return string;
        }
        if (domElement instanceof Evaluate) {
            Evaluate evaluate = (Evaluate)domElement;
            String string = WebflowDiagramElementManager.getAssignmentPresentableName(evaluate.getExpression(), evaluate.getResult());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/diagram/managers/WebflowDiagramElementManager", "getDomElementPresentableName"));
            }
            return string;
        }
        if (domElement instanceof Set) {
            Set set = (Set)domElement;
            String string = WebflowDiagramElementManager.getAssignmentPresentableName(set.getName(), set.getValue());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/diagram/managers/WebflowDiagramElementManager", "getDomElementPresentableName"));
            }
            return string;
        }
        if (domElement instanceof Attribute) {
            Attribute attribute = (Attribute)domElement;
            GenericAttributeValue<String> valueElement = DomUtil.hasXml(attribute.getValueAttr()) ? attribute.getValueAttr() : attribute.getValue();
            String string = WebflowDiagramElementManager.getAssignmentPresentableName(attribute.getName(), valueElement);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/diagram/managers/WebflowDiagramElementManager", "getDomElementPresentableName"));
            }
            return string;
        }
        if (domElement instanceof Input) {
            Input input = (Input)domElement;
            String string = WebflowDiagramElementManager.getAssignmentPresentableName(input.getName(), input.getValue());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/diagram/managers/WebflowDiagramElementManager", "getDomElementPresentableName"));
            }
            return string;
        }
        if (domElement instanceof Output) {
            Output output = (Output)domElement;
            String string = WebflowDiagramElementManager.getAssignmentPresentableName(output.getName(), output.getValue());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/diagram/managers/WebflowDiagramElementManager", "getDomElementPresentableName"));
            }
            return string;
        }
        String presentationName = domElement.getPresentation().getElementName();
        if (presentationName != null) {
            String string = presentationName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/diagram/managers/WebflowDiagramElementManager", "getDomElementPresentableName"));
            }
            return string;
        }
        String string = "<<unknown>>" + domElement.getClass();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/diagram/managers/WebflowDiagramElementManager", "getDomElementPresentableName"));
        }
        return string;
    }

    private static String getAssignmentPresentableName(GenericAttributeValue name, GenericDomValue value) {
        return name.getStringValue() + WebflowDiagramPresentationConstants.LABEL_ASSIGNMENT_OPERATOR + value.getStringValue();
    }

    public String getNodeTooltip(WebflowElementWrapper element) {
        Object o = element.getElement();
        if (o instanceof DomElement) {
            DomElement domElement = (DomElement)o;
            if (!domElement.isValid()) {
                return "<invalid>";
            }
            return domElement.getPresentation().getTypeName();
        }
        return element.getName();
    }

    public Object[] getNodeItems(WebflowElementWrapper parent) {
        Object element = parent.getElement();
        assert (element instanceof DomElement) : element;
        if (!((DomElement)element).isValid()) {
            return EMPTY_ARRAY;
        }
        ArrayList<Object> nodeElements = new ArrayList<Object>();
        if (element instanceof ViewState) {
            ViewState viewState = (ViewState)element;
            WebflowDiagramElementManager.addPropertyLine(nodeElements, "View", viewState.getView().getStringValue());
            WebflowDiagramElementManager.addPropertyLine(nodeElements, "Model", viewState.getModel().getStringValue());
            WebflowDiagramElementManager.addPropertyLine(nodeElements, "Secured", viewState.getSecured().getMatch().getStringValue());
            WebflowDiagramElementManager.addPropertyLine(nodeElements, "Popup", viewState.getPopup().getStringValue());
            nodeElements.addAll(viewState.getVars());
        }
        if (element instanceof SubflowState) {
            SubflowState subflowState = (SubflowState)element;
            WebflowDiagramElementManager.addPropertyLine(nodeElements, "Secured", subflowState.getSecured().getMatch().getStringValue());
            nodeElements.addAll(subflowState.getInputs());
            nodeElements.addAll(subflowState.getOutputs());
        }
        if (element instanceof DecisionState) {
            DecisionState decisionState = (DecisionState)element;
            WebflowDiagramElementManager.addPropertyLine(nodeElements, "Secured", decisionState.getSecured().getMatch().getStringValue());
            nodeElements.addAll(decisionState.getIfs());
        }
        if (element instanceof EndState) {
            EndState endState = (EndState)element;
            WebflowDiagramElementManager.addPropertyLine(nodeElements, "View", endState.getView().getStringValue());
            WebflowDiagramElementManager.addPropertyLine(nodeElements, "Commit", endState.getCommit().getStringValue());
            nodeElements.addAll(endState.getOutputs());
        }
        if (element instanceof ActionsOwner) {
            ActionsOwner owner = (ActionsOwner)element;
            nodeElements.addAll(ContainerUtil.concat(owner.getActions(), owner.getBeanActions()));
        }
        if (element instanceof SetsOwner) {
            nodeElements.addAll(((SetsOwner)element).getSets());
        }
        if (element instanceof SetOwner) {
            nodeElements.addAll(((SetOwner)element).getSets());
        }
        if (element instanceof EvaluatesOwner) {
            nodeElements.addAll(((EvaluatesOwner)element).getEvaluates());
        }
        if (element instanceof ExceptionHandlerOwner) {
            nodeElements.addAll(((ExceptionHandlerOwner)element).getExceptionHandlers());
        }
        if (element instanceof AttributesOwner) {
            nodeElements.addAll(((AttributesOwner)element).getAttributes());
        }
        if (element instanceof RendersOwner) {
            nodeElements.addAll(((RendersOwner)element).getRenders());
        }
        return ArrayUtil.toObjectArray(nodeElements);
    }

    public Icon getItemIcon(Object element, DiagramState presentation) {
        if (element instanceof SimpleColoredText) {
            return EmptyIcon.ICON_0;
        }
        if (element instanceof DomElement) {
            DomElement domElement = (DomElement)element;
            if (!domElement.isValid()) {
                return AllIcons.Nodes.ErrorIntroduction;
            }
            Icon icon = domElement.getPresentation().getIcon();
            return icon != null ? icon : EmptyIcon.ICON_16;
        }
        return super.getItemIcon(element, presentation);
    }

    public SimpleColoredText getItemType(Object element) {
        if (element instanceof DomElement && !((DomElement)element).isValid()) {
            return WebflowDiagramPresentationConstants.INVALID_SIMPLE_COLORED_TEXT;
        }
        if (element instanceof Var) {
            PsiType psiType = (PsiType)((Var)element).getClazz().getValue();
            if (psiType == null) {
                return null;
            }
            return new SimpleColoredText(psiType.getPresentableText(), DEFAULT_TEXT_ATTR);
        }
        if (element instanceof Input) {
            return WebflowDiagramElementManager.createPsiClassPresentableType(((Input)element).getType());
        }
        if (element instanceof Evaluate) {
            return WebflowDiagramElementManager.createPsiClassPresentableType(((Evaluate)element).getResultType());
        }
        if (element instanceof Attribute) {
            return WebflowDiagramElementManager.createPsiClassPresentableType(((Attribute)element).getType());
        }
        return super.getItemType(element);
    }

    public String getEditorTitle(WebflowElementWrapper element, DiagramState presentation, Collection<WebflowElementWrapper> additionalElements) {
        return element.getName();
    }

    @Nullable
    private static SimpleColoredText createPsiClassPresentableType(GenericAttributeValue<PsiClass> clazzAttribute) {
        PsiClass value = (PsiClass)clazzAttribute.getValue();
        if (value == null || value.getName() == null) {
            return null;
        }
        return new SimpleColoredText(value.getName(), DEFAULT_TEXT_ATTR);
    }

    private static void addPropertyLine(List<Object> nodeElements, @NotNull String propertyName, @Nullable String propertyValue) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/spring/webflow/diagram/managers/WebflowDiagramElementManager", "addPropertyLine"));
        }
        if (propertyValue == null || propertyValue.isEmpty()) {
            return;
        }
        SimpleColoredText text = new SimpleColoredText(propertyName + ": ", SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
        text.append(propertyValue, DEFAULT_TEXT_ATTR);
        nodeElements.add(text);
    }
}

