/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.el.inject;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.jsp.el.ELContextProvider;
import com.intellij.psi.impl.source.jsp.el.ELUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.webflow.el.inject.ExpressionLanguageConfiguration;
import com.intellij.spring.webflow.el.inject.ExpressionLanguageConfigurationDeterminer;
import com.intellij.spring.webflow.el.inject.WebflowELExpressionContextProvider;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.spring.webflow.util.WebflowUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WebflowELInjector
implements MultiHostInjector {
    private static final List<Pair<String, String>> expressionTypeAttributes = new ArrayList<Pair<String, String>>();
    private static final List<XmlAttributeValuePattern> myPatterns = new ArrayList<XmlAttributeValuePattern>();

    private static void initPatterns() {
        for (Pair<String, String> pair : expressionTypeAttributes) {
            String tagName = (String)pair.first;
            String attributeName = (String)pair.second;
            myPatterns.add((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withLocalName(new String[]{attributeName}).withSuperParent(2, (ElementPattern)XmlPatterns.xmlTag().withLocalName(tagName)));
        }
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/webflow/el/inject/WebflowELInjector", "getLanguagesToInject"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/spring/webflow/el/inject/WebflowELInjector", "getLanguagesToInject"));
        }
        PsiFile containingFile = host.getContainingFile();
        if (!JamCommonUtil.isPlainXmlFile((PsiElement)containingFile)) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)host);
        if (!WebflowUtil.isWebFlowAvailable(module)) {
            return;
        }
        if (!WebflowELInjector.isWebflowFile((XmlFile)containingFile)) {
            return;
        }
        XmlAttributeValue xmlAttributeValue = (XmlAttributeValue)host;
        if (host.getTextLength() < 2) {
            return;
        }
        ExpressionLanguageConfigurationDeterminer instance = ExpressionLanguageConfigurationDeterminer.getInstance(module);
        ExpressionLanguageConfiguration configuration = instance.determine();
        if (configuration.language == null) {
            return;
        }
        if (WebflowELInjector.acceptExpressionXmlAttributeValue(xmlAttributeValue)) {
            int length = xmlAttributeValue.getValue().length();
            registrar.startInjecting(configuration.language).addPlace(configuration.injectionPrefix, configuration.injectionSuffix, (PsiLanguageInjectionHost)host, TextRange.from((int)1, (int)length)).doneInjecting();
            host.putUserData(ELContextProvider.ourContextProviderKey, (Object)new WebflowELExpressionContextProvider(host));
            return;
        }
        if (xmlAttributeValue.getValue().contains(configuration.detectionPrefix)) {
            List ranges = ELUtil.getELTextRanges((PsiElement)host, (String)configuration.detectionPrefix, (String)configuration.detectionSuffix);
            if (ranges.isEmpty()) {
                return;
            }
            for (TextRange textRange : ranges) {
                if (configuration.stripDetectionStrings) {
                    textRange = TextRange.from((int)(textRange.getStartOffset() + configuration.detectionPrefix.length()), (int)(textRange.getLength() - configuration.detectionPrefix.length() - configuration.detectionSuffix.length()));
                }
                registrar.startInjecting(configuration.language).addPlace(configuration.injectionPrefix, configuration.injectionSuffix, (PsiLanguageInjectionHost)host, textRange).doneInjecting();
            }
            host.putUserData(ELContextProvider.ourContextProviderKey, (Object)new WebflowELExpressionContextProvider(host));
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(XmlAttributeValue.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/el/inject/WebflowELInjector", "elementsToInjectIn"));
        }
        return list;
    }

    private static boolean isWebflowFile(XmlFile file) {
        WebflowDomModelManager domModelManager = WebflowDomModelManager.getInstance(file.getProject());
        return domModelManager.isWebflow(file);
    }

    private static boolean acceptExpressionXmlAttributeValue(XmlAttributeValue value) {
        for (XmlAttributeValuePattern myPattern : myPatterns) {
            if (!myPattern.accepts((Object)value)) continue;
            return true;
        }
        return false;
    }

    static {
        expressionTypeAttributes.add((Pair<String, String>)Pair.create((Object)"evaluate", (Object)"expression"));
        expressionTypeAttributes.add((Pair<String, String>)Pair.create((Object)"evaluate", (Object)"result"));
        expressionTypeAttributes.add((Pair<String, String>)Pair.create((Object)"if", (Object)"test"));
        expressionTypeAttributes.add((Pair<String, String>)Pair.create((Object)"view-state", (Object)"model"));
        expressionTypeAttributes.add((Pair<String, String>)Pair.create((Object)"set", (Object)"name"));
        expressionTypeAttributes.add((Pair<String, String>)Pair.create((Object)"set", (Object)"value"));
        expressionTypeAttributes.add((Pair<String, String>)Pair.create((Object)"input", (Object)"value"));
        expressionTypeAttributes.add((Pair<String, String>)Pair.create((Object)"output", (Object)"value"));
        WebflowELInjector.initPatterns();
    }
}

