/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model.converters;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.impl.GenericDomValueReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebflowAliasClassConverter
extends ResolvingConverter<PsiClass>
implements CustomReferenceConverter {
    private static final JavaClassReferenceProvider REFERENCE_PROVIDER = new JavaClassReferenceProvider();
    private final Map<String, String> aliases = new HashMap<String, String>();

    public WebflowAliasClassConverter() {
        this.aliases.put("boolean", Boolean.class.getName());
        this.aliases.put("byte", Byte.class.getName());
        this.aliases.put("class", Class.class.getName());
        this.aliases.put("double", Double.class.getName());
        this.aliases.put("float", Float.class.getName());
        this.aliases.put("int", Integer.class.getName());
        this.aliases.put("integer", Integer.class.getName());
        this.aliases.put("long", Long.class.getName());
        this.aliases.put("short", Short.class.getName());
        this.aliases.put("string", String.class.getName());
        this.aliases.put("bigInteger", BigInteger.class.getName());
        this.aliases.put("bigDecimal", BigDecimal.class.getName());
        this.aliases.put("labeledEnum", "org.springframework.core.enums.LabeledEnum");
        this.aliases.put("dataModel", "org.springframework.faces.model.OneSelectionTrackingListDataModel");
    }

    @NotNull
    public Collection<? extends PsiClass> getVariants(ConvertContext context) {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/WebflowAliasClassConverter", "getVariants"));
        }
        return list;
    }

    public PsiClass fromString(@Nullable @NonNls String s, ConvertContext context) {
        String aliasClass = this.aliases.get(s);
        return DomJavaUtil.findClass((String)(aliasClass == null ? s : aliasClass), (DomElement)context.getInvocationElement());
    }

    public String toString(@Nullable PsiClass aClass, ConvertContext context) {
        return aClass == null ? null : aClass.getName();
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue value, PsiElement element, ConvertContext context) {
        Object[] references = REFERENCE_PROVIDER.getReferencesByElement(element);
        PsiReference[] psiReferenceArray = (PsiReference[])ArrayUtil.append((Object[])references, (Object)new GenericDomValueReference(value), (ArrayFactory)PsiReference.ARRAY_FACTORY);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/WebflowAliasClassConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    @NotNull
    public Set<String> getAdditionalVariants(@NotNull ConvertContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/webflow/model/converters/WebflowAliasClassConverter", "getAdditionalVariants"));
        }
        Set<String> set = this.aliases.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/WebflowAliasClassConverter", "getAdditionalVariants"));
        }
        return set;
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return CodeInsightBundle.message((String)"error.cannot.resolve.class", (Object[])new Object[]{s});
    }

    static {
        REFERENCE_PROVIDER.setSoft(true);
        REFERENCE_PROVIDER.setAllowEmpty(false);
    }
}

