/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.spring.webflow.model.impl.WebflowDomModelFactory;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.spring.webflow.model.xml.ViewOwner;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebflowDomModelManagerImpl
extends WebflowDomModelManager {
    private final WebflowDomModelFactory myDomModelFactory;
    private final DomManager myDomManager;

    public WebflowDomModelManagerImpl(Project project, DomManager domManager) {
        this.myDomManager = domManager;
        this.myDomModelFactory = new WebflowDomModelFactory(project);
    }

    @Override
    public boolean isWebflow(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/webflow/model/impl/WebflowDomModelManagerImpl", "isWebflow"));
        }
        return this.myDomManager.getFileElement(file, Flow.class) != null;
    }

    @Override
    @Nullable
    public WebflowModel getWebflowModel(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/webflow/model/impl/WebflowDomModelManagerImpl", "getWebflowModel"));
        }
        return (WebflowModel)this.myDomModelFactory.getModelByConfigFile(file);
    }

    @Override
    public List<WebflowModel> getAllModels(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/webflow/model/impl/WebflowDomModelManagerImpl", "getAllModels"));
        }
        return this.myDomModelFactory.getAllModels((UserDataHolder)module);
    }

    @Override
    public List<WebflowModel> getModelsForView(@NotNull PsiFile viewFile) {
        if (viewFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewFile", "com/intellij/spring/webflow/model/impl/WebflowDomModelManagerImpl", "getModelsForView"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)viewFile);
        if (module == null) {
            return Collections.emptyList();
        }
        List<WebflowModel> allModels = this.getAllModels(module);
        return ContainerUtil.filter(allModels, webflowModel -> {
            if (viewFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewFile", "com/intellij/spring/webflow/model/impl/WebflowDomModelManagerImpl", "lambda$getModelsForView$1"));
            }
            Flow flow = webflowModel.getFlow();
            List viewOwners = DomUtil.getDefinedChildrenOfType((DomElement)flow, ViewOwner.class, (boolean)true, (boolean)false);
            return ContainerUtil.exists((Iterable)viewOwners, owner -> {
                if (viewFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewFile", "com/intellij/spring/webflow/model/impl/WebflowDomModelManagerImpl", "lambda$null$0"));
                }
                return Comparing.equal((Object)owner.getResolvedView(), (Object)viewFile);
            });
        });
    }

    @Override
    public Flow findFlowByName(@NotNull Module module, String name) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/webflow/model/impl/WebflowDomModelManagerImpl", "findFlowByName"));
        }
        WebflowModel webflowModel = (WebflowModel)ContainerUtil.find(this.getAllModels(module), model -> Comparing.equal((String)model.getName(), (String)name));
        return webflowModel != null ? webflowModel.getFlow() : null;
    }
}

