/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model.impl;

import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.model.impl.DomModelImpl;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WebflowModelImpl
extends DomModelImpl<Flow>
implements WebflowModel {
    @NotNull
    private final DomElement myDefinition;
    @NotNull
    private final String myName;

    public WebflowModelImpl(@NotNull DomFileElement<Flow> mergedModel, @NotNull Set<XmlFile> configFiles, @NotNull DomElement definition, @NotNull String name) {
        if (mergedModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedModel", "com/intellij/spring/webflow/model/impl/WebflowModelImpl", "<init>"));
        }
        if (configFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFiles", "com/intellij/spring/webflow/model/impl/WebflowModelImpl", "<init>"));
        }
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/spring/webflow/model/impl/WebflowModelImpl", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/webflow/model/impl/WebflowModelImpl", "<init>"));
        }
        super(mergedModel, configFiles);
        this.myDefinition = definition;
        this.myName = name;
        assert (configFiles.size() == 1) : configFiles.size() + " " + name;
    }

    @Override
    @NotNull
    public DomElement getDefinition() {
        DomElement domElement = this.myDefinition;
        if (domElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/impl/WebflowModelImpl", "getDefinition"));
        }
        return domElement;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/impl/WebflowModelImpl", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public Flow getFlow() {
        Flow flow = (Flow)this.getMergedModel();
        if (flow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/impl/WebflowModelImpl", "getFlow"));
        }
        return flow;
    }

    @Override
    @NotNull
    public XmlFile getFlowFile() {
        Set files = this.getConfigFiles();
        XmlFile xmlFile = (XmlFile)files.iterator().next();
        if (xmlFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/impl/WebflowModelImpl", "getFlowFile"));
        }
        return xmlFile;
    }

    public String toString() {
        return "WebflowDomModel[" + this.myName + ":" + this.getFlowFile().getName() + " -> " + this.getDefinition().getXmlElementName() + "]";
    }
}

