/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.impl.TemplatePreprocessor;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.JspSpiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlUtil;

public class JspxTemplatePreprocessor
implements TemplatePreprocessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.template.impl.JspxTemplatePreprocessor");

    public void preprocessTemplate(Editor editor, PsiFile file, int caretOffset, String textToInsert, String templateText) {
        if (file.getLanguage().equals(StdLanguages.JSPX) && file instanceof JspFile && XmlUtil.toCode((String)textToInsert)) {
            Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)file, (int)caretOffset);
            if (language != JavaLanguage.INSTANCE) {
                return;
            }
            try {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
                    int offset = caretOffset + JspSpiUtil.escapeCharsInJspContext((JspFile)((JspFile)file), (int)caretOffset, (String)templateText);
                    PostprocessReformattingAspect.getInstance((Project)file.getProject()).doPostponedFormatting();
                    editor.getCaretModel().moveToOffset(offset);
                });
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }
}

