/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspTextSyntheticBlock
implements Block {
    private final Block myParentBlock;
    private Indent myIndent;
    private final List<Block> mySubBlocks;
    private final int myFromIndex;
    private final TextRange myTextRange;
    private Spacing mySpacing;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.formatter.xml.JspTextSyntheticBlock");

    public JspTextSyntheticBlock(Block parentBlock, int fromIndex, Indent indent, List<Block> subBlocks) {
        for (Block subBlock : subBlocks) {
            if (subBlock == null) assert (false);
        }
        this.myParentBlock = parentBlock;
        this.myIndent = indent;
        this.mySubBlocks = subBlocks;
        this.myFromIndex = fromIndex;
        this.myTextRange = new TextRange(subBlocks.get(0).getTextRange().getStartOffset(), subBlocks.get(subBlocks.size() - 1).getTextRange().getEndOffset());
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/xml/JspTextSyntheticBlock", "getTextRange"));
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        List<Block> list = this.mySubBlocks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/xml/JspTextSyntheticBlock", "getSubBlocks"));
        }
        return list;
    }

    @Nullable
    public Wrap getWrap() {
        return null;
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    @Nullable
    public Alignment getAlignment() {
        return null;
    }

    @Nullable
    public Spacing getSpacing() {
        return this.mySpacing;
    }

    public void setSpacing(@Nullable Spacing spacing) {
        this.mySpacing = spacing;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        if (newChildIndex > 0 && this.mySubBlocks.get(newChildIndex - 1) instanceof JspTextSyntheticBlock) {
            ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_PREV_CHILD;
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/xml/JspTextSyntheticBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (newChildIndex == 0 && this.mySubBlocks.get(0) instanceof JspTextSyntheticBlock) {
            ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_NEXT_CHILD;
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/xml/JspTextSyntheticBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        ChildAttributes childAttributes = this.myParentBlock.getChildAttributes(this.myFromIndex + newChildIndex);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/xml/JspTextSyntheticBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    public boolean isIncomplete() {
        return this.myParentBlock.isIncomplete();
    }

    @Nullable
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        Block second;
        Block first;
        Spacing result;
        JspTextSyntheticBlock childEx;
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/psi/formatter/xml/JspTextSyntheticBlock", "getSpacing"));
        }
        if (child1 instanceof JspTextSyntheticBlock) {
            childEx = (JspTextSyntheticBlock)child1;
            result = childEx.getSpacing();
            if (result != null) {
                return result;
            }
            first = childEx.myParentBlock;
        } else {
            first = child1;
        }
        if (child2 instanceof JspTextSyntheticBlock) {
            childEx = (JspTextSyntheticBlock)child2;
            result = childEx.getSpacing();
            if (result != null) {
                return result;
            }
            second = childEx.myParentBlock;
        } else {
            second = child2;
        }
        if (!this.myParentBlock.getSubBlocks().contains(first)) {
            LOG.assertTrue(false);
        }
        if (!this.myParentBlock.getSubBlocks().contains(second)) {
            LOG.assertTrue(false);
        }
        return this.myParentBlock.getSpacing(first, second);
    }

    public void setIndent(Indent parentIndent) {
        this.myIndent = parentIndent;
    }

    public boolean isLeaf() {
        return false;
    }

    public String toString() {
        Block block = this.myParentBlock;
        while (block != null) {
            if (block instanceof ASTBlock) {
                String text = ((ASTBlock)block).getNode().getPsi().getContainingFile().getText();
                return this.myTextRange.substring(text) + " " + this.myTextRange;
            }
            if (!(block instanceof JspTextSyntheticBlock)) break;
            block = ((JspTextSyntheticBlock)block).myParentBlock;
        }
        return super.toString();
    }
}

