/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.jsp.index.JspDirectiveCollector;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.jsp.JspxFileViewProvider;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.html.ScriptSupportUtil;
import com.intellij.psi.impl.source.jsp.BaseJspFileImpl;
import com.intellij.psi.impl.source.jsp.JspContextManager;
import com.intellij.psi.impl.source.jsp.JspJavaFileImpl;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.JavaJspElementVisitor;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.JspUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspFileImpl
extends BaseJspFileImpl
implements JspFile,
PsiJavaFile {
    public JspFileImpl(@NotNull JspxFileViewProvider viewProvider) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/impl/source/jsp/JspFileImpl", "<init>"));
        }
        super(viewProvider);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/jsp/JspFileImpl", "accept"));
        }
        if (visitor instanceof JavaJspElementVisitor) {
            ((JavaJspElementVisitor)visitor).visitJspFile((JspFile)this);
        } else {
            visitor.visitFile((PsiFile)this);
        }
    }

    @NotNull
    public JspClass getJavaClass() {
        JspJavaFileImpl psiFile = this.getJavaRoot();
        JspClass jspClass = psiFile.getJavaClass();
        if (jspClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspFileImpl", "getJavaClass"));
        }
        return jspClass;
    }

    private JspJavaFileImpl getJavaRoot() {
        return (JspJavaFileImpl)this.getViewProvider().getPsi((Language)JavaLanguage.INSTANCE);
    }

    @Override
    protected <T extends BaseJspFile> void visitAllIncludedFilesRecursively(T baseJspFile, Processor<T> processor) {
        JspUtil.visitAllIncludedFilesRecursively(baseJspFile, processor, true);
    }

    public XmlTag[] getDirectiveTagsInContext(JspDirectiveKind directiveKind) {
        return JspFileImpl.getTags(directiveKind, this);
    }

    @NotNull
    public static XmlTag[] getTags(JspDirectiveKind directiveKind, BaseJspFile file) {
        ArrayList directives = new ArrayList();
        Processor fileProcessor = jspFile -> {
            directives.addAll(JspDirectiveCollector.collectDirectives(jspFile, directiveKind));
            return true;
        };
        Project project = file.getProject();
        if (project.isDefault()) {
            fileProcessor.process((Object)file);
        } else {
            JspContextManager manager = JspContextManager.getInstance((Project)project);
            BaseJspFile rootContext = manager.getRootContextFile(file);
            fileProcessor.process((Object)rootContext);
            JspUtil.visitAllIncludedFilesRecursively(rootContext, fileProcessor, true);
        }
        XmlTag[] xmlTagArray = directives.toArray(new XmlTag[directives.size()]);
        if (xmlTagArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspFileImpl", "getTags"));
        }
        return xmlTagArray;
    }

    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] psiClassArray = this.getJavaRoot().getClasses();
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspFileImpl", "getClasses"));
        }
        return psiClassArray;
    }

    @Nullable
    public PsiPackageStatement getPackageStatement() {
        return this.getJavaRoot().getPackageStatement();
    }

    @NotNull
    public String getPackageName() {
        String string = this.getJavaRoot().getPackageName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspFileImpl", "getPackageName"));
        }
        return string;
    }

    public void setPackageName(String packageName) throws IncorrectOperationException {
        throw new IncorrectOperationException("Cannot set package name for jsp files");
    }

    @Nullable
    public PsiImportList getImportList() {
        return this.getJavaRoot().getImportList();
    }

    public boolean importClass(PsiClass aClass) {
        return JavaCodeStyleManager.getInstance((Project)this.getProject()).addImport((PsiJavaFile)this, aClass);
    }

    @NotNull
    public String[] getImplicitlyImportedPackages() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspFileImpl", "getImplicitlyImportedPackages"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @NotNull
    public PsiJavaCodeReferenceElement[] getImplicitlyImportedPackageReferences() {
        if (PsiJavaCodeReferenceElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspFileImpl", "getImplicitlyImportedPackageReferences"));
        }
        return PsiJavaCodeReferenceElement.EMPTY_ARRAY;
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = this.getJavaRoot().getLanguageLevel();
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspFileImpl", "getLanguageLevel"));
        }
        return languageLevel;
    }

    @Nullable
    public PsiJavaModule getModuleDeclaration() {
        return null;
    }

    @NotNull
    public PsiClass[] getSingleClassImports(boolean checkIncludes) {
        if (PsiClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspFileImpl", "getSingleClassImports"));
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @NotNull
    public PsiElement[] getOnDemandImports(boolean includeImplicit, boolean checkIncludes) {
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspFileImpl", "getOnDemandImports"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/jsp/JspFileImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/jsp/JspFileImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/jsp/JspFileImpl", "processDeclarations"));
        }
        boolean b = super.processDeclarations(processor, state, lastParent, place);
        if (b && this.getLanguage() == StdLanguages.JSPX) {
            b = ScriptSupportUtil.processDeclarations((XmlFile)this, (PsiScopeProcessor)processor, (ResolveState)state, (PsiElement)lastParent, (PsiElement)place);
        }
        return b;
    }

    public PsiJavaCodeReferenceElement findImportReferenceTo(PsiClass aClass) {
        return null;
    }
}

