/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp.el;

import com.intellij.jsp.impl.FunctionDescriptor;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.jsp.el.impl.ELResolveUtil;
import com.intellij.psi.jsp.el.ELExpression;
import com.intellij.psi.jsp.el.ELFunctionCallExpression;
import com.intellij.psi.jsp.el.ELMethodCallExpression;
import com.intellij.psi.jsp.el.ELParameterList;
import com.intellij.psi.jsp.el.ELVariable;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;

public class ELAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/psi/impl/source/jsp/el/ELAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/impl/source/jsp/el/ELAnnotator", "annotate"));
        }
        if (psiElement instanceof ELFunctionCallExpression) {
            PsiElement element;
            ELFunctionCallExpression callExpression = (ELFunctionCallExpression)psiElement;
            ELVariable method = callExpression.getMethod();
            PsiReference reference = method != null ? method.getReference() : null;
            PsiElement psiElement2 = element = reference != null ? reference.resolve() : null;
            if (element instanceof XmlTag) {
                FunctionDescriptor data = (FunctionDescriptor)element.getUserData(ELResolveUtil.EL_FUNCTION_DESCRIPTOR);
                ELParameterList parameterList = callExpression.getParameterList();
                if (parameterList != null && data != null && parameterList.getParameters().length != data.getParameterCount()) {
                    holder.createErrorAnnotation((PsiElement)parameterList, PsiBundle.message((String)"el.mismatched.parameters.count", (Object[])new Object[0]));
                }
            }
        } else if (psiElement instanceof ELMethodCallExpression) {
            PsiElement element;
            ELMethodCallExpression methodCallExpression = (ELMethodCallExpression)psiElement;
            ELVariable elVariable = methodCallExpression.getMethod();
            PsiElement psiElement3 = element = elVariable != null ? elVariable.getReferences()[0].resolve() : null;
            if (element instanceof PsiMethod) {
                ELExpression[] parameters;
                PsiParameter[] psiParameters = ((PsiMethod)element).getParameterList().getParameters();
                ELParameterList parameterList = methodCallExpression.getParameterList();
                ELExpression[] eLExpressionArray = parameters = parameterList != null ? parameterList.getParameters() : null;
                if (parameters != null && parameters.length != psiParameters.length) {
                    holder.createErrorAnnotation((PsiElement)parameterList, PsiBundle.message((String)"el.mismatched.parameters.count", (Object[])new Object[0]));
                }
            }
        }
    }
}

