/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.Annotations;

import com.intellij.openapi.vcs.VcsException;

public class AnnotationLineParser {
    public static final String FIELDS_DELIMITER = " #|# ";
    public static final String FIELDS_DELIMITER_RE = " #\\|# ";
    private static final AnnotationLineInfo _cachedValues = new AnnotationLineInfo();

    private AnnotationLineParser() {
    }

    public static AnnotationLineInfo parse(String line) throws VcsException {
        AnnotationLineInfo info = new AnnotationLineInfo();
        String[] tokens = line.split(FIELDS_DELIMITER_RE);
        try {
            if (AnnotationLineParser.isValueableToken(tokens[0])) {
                AnnotationLineParser._cachedValues.date = info.date = tokens[0].trim();
            } else {
                info.date = AnnotationLineParser._cachedValues.date;
            }
            if (AnnotationLineParser.isValueableToken(tokens[1])) {
                AnnotationLineParser._cachedValues.committer = info.committer = tokens[1].trim();
            } else {
                info.committer = AnnotationLineParser._cachedValues.committer;
            }
            if (AnnotationLineParser.isValueableToken(tokens[2])) {
                AnnotationLineParser._cachedValues.revision = info.revision = tokens[2].trim();
            } else {
                info.revision = AnnotationLineParser._cachedValues.revision;
            }
            info.source = tokens.length > 3 ? tokens[3] : "";
        }
        catch (Exception e) {
            throw new VcsException("Can not parse annotation log: " + line);
        }
        return info;
    }

    private static boolean isValueableToken(String token) {
        String trimmed = token.trim();
        return trimmed.length() > 0 && !trimmed.equals(".");
    }

    public static class AnnotationLineInfo {
        public String duration;
        public String committer;
        public String date;
        public String revision;
        public String source;
    }
}

