/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.InternationalFormatter;
import net.sourceforge.transparent.CCaseConfig;
import net.sourceforge.transparent.CCaseSharedConfig;
import net.sourceforge.transparent.CCaseViewsManager;
import net.sourceforge.transparent.TransparentVcs;
import org.jetbrains.annotations.NonNls;

public class CCaseConfigurable
implements Configurable {
    @NonNls
    private static final String OPTIONS_SCREEN_NAME = "ClearCase Options";
    private JCheckBox myWorkOffline;
    private JCheckBox myReservedCheckoutsCheckBox;
    private JCheckBox myCheckOutForHijacked;
    private JCheckBox myUseUCMModel;
    private JCheckBox myRestrictHistory;
    private JFormattedTextField historyText;
    private JTextField scrText;
    private JPanel myConfigPanel;
    private JCheckBox useIdenticalSwitch;
    private JCheckBox synchActivitiesOnRefresh;
    private final Project project;
    private CCaseSharedConfig mySharedConfig;
    private CCaseConfig vcsConfig;

    public CCaseConfigurable(Project project) {
        this.project = project;
        this.$$$setupUI$$$();
    }

    public void disposeUIResources() {
    }

    public String getDisplayName() {
        return OPTIONS_SCREEN_NAME;
    }

    public String getHelpTopic() {
        return "project.propVCSSupport.VCSs.ClearCase";
    }

    public JComponent createComponent() {
        this.vcsConfig = CCaseConfig.getInstance(this.project);
        this.mySharedConfig = CCaseSharedConfig.getInstance(this.project);
        this.myWorkOffline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CCaseConfigurable.this.resetCheckInOutCheckboxes();
            }
        });
        this.myRestrictHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CCaseConfigurable.this.resetHistoryMargin();
            }
        });
        return this.myConfigPanel;
    }

    private void resetCheckInOutCheckboxes() {
        boolean isOffline = this.myWorkOffline.isSelected();
        this.myReservedCheckoutsCheckBox.setEnabled(!isOffline);
        this.myCheckOutForHijacked.setEnabled(!isOffline);
        this.myUseUCMModel.setEnabled(!isOffline);
        if (isOffline) {
            this.myCheckOutForHijacked.setSelected(true);
        }
    }

    private void resetHistoryMargin() {
        this.historyText.setEnabled(this.myRestrictHistory.isSelected());
    }

    public boolean isModified() {
        CCaseSharedConfig.State state = this.mySharedConfig.getState();
        return this.hasScrTextChanged() || this.vcsConfig.checkoutReserved != this.myReservedCheckoutsCheckBox.isSelected() || this.vcsConfig.checkInUseHijack != this.myCheckOutForHijacked.isSelected() || (state == null ? true : state.myUseUcmModel) != this.myUseUCMModel.isSelected() || this.vcsConfig.isOffline() != this.myWorkOffline.isSelected() || this.vcsConfig.isHistoryResticted != this.myRestrictHistory.isSelected() || this.vcsConfig.getHistoryRevisionsMargin() != this.getMargin() || this.vcsConfig.useIdenticalSwitch != this.useIdenticalSwitch.isSelected() || this.vcsConfig.synchActivitiesOnRefresh != this.synchActivitiesOnRefresh.isSelected();
    }

    private boolean hasScrTextChanged() {
        return this.vcsConfig.scrTextFileName == null || !this.vcsConfig.scrTextFileName.equals(this.scrText.getText());
    }

    public void apply() throws ConfigurationException {
        boolean ucmFlagChanged = this.mySharedConfig.isUseUcmModel() != this.myUseUCMModel.isSelected();
        boolean need2ReloadActivities = ucmFlagChanged && this.myUseUCMModel.isSelected();
        this.vcsConfig.checkoutReserved = this.myReservedCheckoutsCheckBox.isSelected();
        this.vcsConfig.checkInUseHijack = this.myCheckOutForHijacked.isSelected();
        this.mySharedConfig.setUcmMode(this.myUseUCMModel.isSelected());
        this.vcsConfig.setOfflineMode(this.myWorkOffline.isSelected());
        this.vcsConfig.isHistoryResticted = this.myRestrictHistory.isSelected();
        this.vcsConfig.setHistoryRevisionsMargin(this.getMargin());
        this.vcsConfig.useIdenticalSwitch = this.useIdenticalSwitch.isSelected();
        this.vcsConfig.synchActivitiesOnRefresh = this.synchActivitiesOnRefresh.isSelected();
        if (ucmFlagChanged) {
            TransparentVcs.getInstance(this.project).checkRootsForUCMMismatch();
        }
        if (need2ReloadActivities) {
            CCaseViewsManager.getInstance(this.project).extractViewActivities();
        }
        this.vcsConfig.scrTextFileName = this.scrText.getText();
    }

    public void reset() {
        this.createComponent();
        this.scrText.setText(this.vcsConfig.scrTextFileName);
        this.myReservedCheckoutsCheckBox.setSelected(this.vcsConfig.checkoutReserved);
        this.myCheckOutForHijacked.setSelected(this.vcsConfig.checkInUseHijack);
        this.myUseUCMModel.setSelected(this.mySharedConfig.isUseUcmModel());
        this.useIdenticalSwitch.setSelected(this.vcsConfig.useIdenticalSwitch);
        this.synchActivitiesOnRefresh.setSelected(this.vcsConfig.synchActivitiesOnRefresh);
        this.myRestrictHistory.setSelected(this.vcsConfig.isHistoryResticted);
        this.historyText.setValue(this.vcsConfig.getHistoryRevisionsMargin());
        this.historyText.setEnabled(this.vcsConfig.isHistoryResticted);
        CCaseViewsManager mgr = CCaseViewsManager.getInstance(this.project);
        this.myWorkOffline.setSelected(mgr.isAnySnapshotView() && this.vcsConfig.isOffline());
        this.myWorkOffline.setEnabled(mgr.isAnySnapshotView());
        this.resetCheckInOutCheckboxes();
    }

    private int getMargin() {
        int margin = this.vcsConfig.getHistoryRevisionsMargin();
        try {
            margin = (int)Long.parseLong(this.historyText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return margin;
    }

    private void createUIComponents() {
        NumberFormat format = NumberFormat.getIntegerInstance();
        format.setParseIntegerOnly(true);
        format.setMinimumIntegerDigits(1);
        format.setMaximumIntegerDigits(4);
        format.setGroupingUsed(false);
        InternationalFormatter formatter = new InternationalFormatter(format);
        formatter.setAllowsInvalid(false);
        formatter.setCommitsOnValidEdit(true);
        formatter.setMinimum(Integer.valueOf(1));
        this.historyText = new JFormattedTextField(formatter);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JPanel jPanel;
        this.createUIComponents();
        this.myConfigPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myWorkOffline = jCheckBox7 = new JCheckBox();
        jCheckBox7.setText("Work Offline (on edit: hijack instead of checkout)");
        jPanel3.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myReservedCheckoutsCheckBox = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("Reserved Checkouts");
        jPanel3.add((Component)jCheckBox6, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCheckOutForHijacked = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Check out automatically hijacked file on check in");
        jPanel3.add((Component)jCheckBox5, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUseUCMModel = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Use UCM model");
        jPanel3.add((Component)jCheckBox4, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.useIdenticalSwitch = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Use \"-identical\" switch during check in");
        jPanel3.add((Component)jCheckBox3, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.synchActivitiesOnRefresh = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(false);
        jCheckBox2.setText("Synchronize activities on refresh");
        jPanel3.add((Component)jCheckBox2, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(6, 0, 1, 1, 9, 0, 3, 3, null, null, null));
        this.myRestrictHistory = jCheckBox = new JCheckBox();
        jCheckBox.setText("Restrict history records:");
        jPanel4.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JFormattedTextField jFormattedTextField = this.historyText;
        jPanel4.add((Component)jFormattedTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(50, -1), null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("SCR text file:");
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.scrText = jTextField = new JTextField();
        jPanel5.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myConfigPanel;
    }
}

