/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.committed.AbstractCalledLater;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateSession;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.transparent.ChangeManagement.CCaseChangeProvider;
import net.sourceforge.transparent.TransparentVcs;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CCaseUpdateEnvironment
implements UpdateEnvironment {
    @NonNls
    private static final String LOADING_SIG = "Loading \"";
    @NonNls
    private static final String KEEP_HIJACKED_SIG = "Keeping hijacked object \"";
    @NonNls
    private static final String UNLOADED_SIG = "Unloaded \"";
    @NonNls
    private static final String BASE_DELIM = " - base ";
    @NonNls
    private static final String VIEW_BASE_PATH_SIG = "Log has been written to";
    @NonNls
    private static final String UPDATE_FILE_PREFIX_SIG = "update.";
    @NonNls
    private static final String PROGRESS_TEXT = "Synching with repository";
    @NonNls
    private static final String ERROR_MSG_SIG = "valid snapshot view path";
    private final Project myProject;

    public CCaseUpdateEnvironment(Project project) {
        this.myProject = project;
    }

    public void fillGroups(UpdatedFiles groups) {
    }

    @NotNull
    public UpdateSession updateDirectories(@NotNull FilePath[] contentRoots, UpdatedFiles updatedFiles, ProgressIndicator progressIndicator, @NotNull Ref<SequentialUpdatesContext> context) throws ProcessCanceledException {
        if (contentRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoots", "net/sourceforge/transparent/CCaseUpdateEnvironment", "updateDirectories"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "net/sourceforge/transparent/CCaseUpdateEnvironment", "updateDirectories"));
        }
        for (FilePath contentRoot : contentRoots) {
            VirtualFile vf = contentRoot.getVirtualFile();
            if (vf == null) continue;
            VfsUtil.processFilesRecursively((VirtualFile)vf, (Processor)new Processor<VirtualFile>(){

                public boolean process(VirtualFile virtualFile) {
                    virtualFile.putUserData(CCaseChangeProvider.ourVersionedKey, null);
                    return true;
                }
            });
        }
        final ArrayList<VcsException> errors = new ArrayList<VcsException>();
        progressIndicator.setText(PROGRESS_TEXT);
        new AbstractCalledLater(this.myProject, ModalityState.NON_MODAL){

            public void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
            }
        }.callMe();
        for (FilePath root : contentRoots) {
            String out = TransparentVcs.cleartoolWithOutput("update", "-force", root.getPath());
            if (out.indexOf(ERROR_MSG_SIG) != -1) {
                errors.add(new VcsException("You can not update a dynamic view: " + out));
                continue;
            }
            CCaseUpdateEnvironment.parseOutput(root.getPath(), out, updatedFiles);
        }
        UpdateSession updateSession = new UpdateSession(){

            @NotNull
            public List<VcsException> getExceptions() {
                ArrayList arrayList = errors;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "net/sourceforge/transparent/CCaseUpdateEnvironment$3", "getExceptions"));
                }
                return arrayList;
            }

            public void onRefreshFilesCompleted() {
            }

            public boolean isCanceled() {
                return false;
            }
        };
        if (updateSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "net/sourceforge/transparent/CCaseUpdateEnvironment", "updateDirectories"));
        }
        return updateSession;
    }

    private static void parseOutput(String contentRoot, String output, UpdatedFiles updatedFiles) {
        String[] lines;
        String sepSymbol = new String(new char[]{File.separatorChar});
        HashSet<String> updated = new HashSet<String>();
        HashSet<String> skipped = new HashSet<String>();
        HashSet<String> deleted = new HashSet<String>();
        String rootPath = contentRoot;
        if (!rootPath.endsWith(sepSymbol)) {
            rootPath = rootPath + sepSymbol;
        }
        for (String line : lines = LineTokenizer.tokenize((char[])output.toCharArray(), (boolean)false, (boolean)true)) {
            int updateFileStart;
            String fileName;
            if (line.startsWith(LOADING_SIG)) {
                int lastQuote = line.lastIndexOf("\"");
                fileName = line.substring(LOADING_SIG.length(), lastQuote);
                updated.add(VcsUtil.getCanonicalLocalPath((String)fileName));
                continue;
            }
            if (line.startsWith(KEEP_HIJACKED_SIG)) {
                int lastQuote = line.lastIndexOf(BASE_DELIM);
                fileName = line.substring(KEEP_HIJACKED_SIG.length(), lastQuote - 1);
                skipped.add(VcsUtil.getCanonicalLocalPath((String)fileName));
                continue;
            }
            if (line.startsWith(UNLOADED_SIG)) {
                String fileName2 = line.substring(UNLOADED_SIG.length(), line.length() - 2);
                deleted.add(VcsUtil.getCanonicalLocalPath((String)fileName2));
                continue;
            }
            if (!line.startsWith(VIEW_BASE_PATH_SIG) || (updateFileStart = line.lastIndexOf(UPDATE_FILE_PREFIX_SIG)) == -1) continue;
            line = line.substring(0, updateFileStart);
            rootPath = line.substring(VIEW_BASE_PATH_SIG.length() + 2);
        }
        VcsKey vcsKey = TransparentVcs.getKey();
        for (String path : updated) {
            updatedFiles.getGroupById("UPDATED").add(rootPath + path, vcsKey, null);
        }
        for (String path : skipped) {
            updatedFiles.getGroupById("SKIPPED").add(rootPath + path, vcsKey, null);
        }
        for (String path : deleted) {
            updatedFiles.getGroupById("REMOVED_FROM_REPOSITORY").add(rootPath + path, vcsKey, null);
        }
    }

    @Nullable
    public Configurable createConfigurable(Collection<FilePath> files) {
        return null;
    }

    public boolean validateOptions(Collection<FilePath> roots) {
        return true;
    }
}

