/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListDecorator;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.HashSet;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.transparent.CCaseConfig;
import net.sourceforge.transparent.CCaseSharedConfig;
import net.sourceforge.transparent.TransparentVcs;
import net.sourceforge.transparent.exceptions.ClearCaseException;
import net.sourceforge.transparent.exceptions.ClearCaseNoServerException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CCaseViewsManager
extends AbstractProjectComponent
implements ChangeListDecorator,
JDOMExternalizable {
    @NonNls
    private static final String PERSISTENCY_SAVED_ACTIVITY_MAP_TAG = "ClearCasePersistencyActivitiesMap";
    @NonNls
    private static final String VIEW_INFO_TAG = "ViewInfo";
    @NonNls
    private static final String CONTENT_ROOT_TAG = "ContentRoot";
    @NonNls
    private static final String TAG_TAG = "Tag";
    @NonNls
    private static final String UUID_TAG = "Uuid";
    @NonNls
    private static final String UCM_TAG = "Ucm";
    @NonNls
    private static final String SNAPSHOT_TAG = "Snapshot";
    @NonNls
    private static final String ACTIVITY_TAG = "Activity";
    @NonNls
    private static final String TAG_SIG = "Tag: ";
    @NonNls
    private static final String TAG_UUID_SIG = "  View tag uuid:";
    @NonNls
    private static final String ATTRIBUTES_SIG = "iew attributes:";
    @NonNls
    private static final String SNAPSHOT_SIG = "snapshot";
    @NonNls
    private static final String UCM_SIG = "ucmview";
    @NonNls
    private static final String LIST_VIEW_CMD = "lsview";
    @NonNls
    private static final String CURRENT_VIEW_SWITCH = "-cview";
    @NonNls
    private static final String VIEW_SWITCH = "-view";
    @NonNls
    private static final String OBSOLETE_SWITCH = "-obsolete";
    @NonNls
    private static final String FORMAT_SWITCH = "-fmt";
    @NonNls
    private static final String LONG_SWITCH = "-long";
    @NonNls
    private static final String LIST_ACTIVITY_CMD = "lsactivity";
    @NonNls
    private static final String ME_ONLY_SWITCH = "-me";
    @NonNls
    private static final String LIST_ACTIVITY_FORMAT = "%n <-> %[locked]p <-> %[headline]p <-> %[view]p\\n";
    @NonNls
    private static final String FIELDS_DELIMITER = " <-> ";
    @NonNls
    private static final String LOCKED_ACTIVITY_SIG = " (LOCKED)";
    @NonNls
    private static final String NOT_ASSOCIATED_CHANGELIST_SIG = " (not associated with any CC activity)";
    @NonNls
    private static final String ERRORS_TAB_NAME = "ClearCase views operations";
    @NonNls
    private static final String SERVER_UNAVAILABLE_MESSAGE = "\nServer is unavailable, ClearCase support is switched to isOffline mode";
    @NonNls
    private static final String FAILED_TO_INIT_VIEW_MESSAGE = "Plugin failed to initialize view:\n";
    @NonNls
    private static final String FAILED_TO_COLLECT_VIEW_MESSAGE = "Plugin failed to collect information on views (absent 'cleartool.exe'?). Plugin is switched to the offline mode.\n";
    public HashMap<String, ViewInfo> viewsMapByRoot = new HashMap();
    private final HashMap<String, String> activitiesAssociations = new HashMap();
    private final HashMap<String, ActivityInfo> activitiesMap = new HashMap();

    @NotNull
    public String getComponentName() {
        if ("CCaseViewsManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "net/sourceforge/transparent/CCaseViewsManager", "getComponentName"));
        }
        return "CCaseViewsManager";
    }

    public static CCaseViewsManager getInstance(Project project) {
        return (CCaseViewsManager)((Object)PeriodicalTasksCloser.getInstance().safeGetComponent(project, CCaseViewsManager.class));
    }

    public CCaseViewsManager(Project project) {
        super(project);
    }

    public boolean isAnyUcmView() {
        boolean status = false;
        for (ViewInfo info : this.viewsMapByRoot.values()) {
            status = status || info.isUcm;
        }
        return status;
    }

    public boolean isAnySnapshotView() {
        boolean status = false;
        for (ViewInfo info : this.viewsMapByRoot.values()) {
            status = status || info.isSnapshot;
        }
        return status;
    }

    @Nullable
    public ViewInfo getViewByRoot(VirtualFile root) {
        return root != null ? this.viewsMapByRoot.get(root.getPath()) : null;
    }

    @Nullable
    public ViewInfo getViewByFile(VirtualFile file) {
        ProjectLevelVcsManager mgr = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        VirtualFile root = mgr.getVcsRootFor(file);
        return this.getViewByRoot(root);
    }

    @Nullable
    public ViewInfo getViewByFile(FilePath file) {
        ProjectLevelVcsManager mgr = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        VirtualFile root = mgr.getVcsRootFor(file);
        return this.getViewByRoot(root);
    }

    @Nullable
    public ActivityInfo getActivityForName(String name) {
        for (ActivityInfo info : this.activitiesMap.values()) {
            if (!info.publicName.equalsIgnoreCase(name)) continue;
            return info;
        }
        return null;
    }

    public boolean isUcmViewForFile(VirtualFile file) {
        ViewInfo view = this.getViewByFile(file);
        return view != null && view.isUcm;
    }

    public boolean isUcmViewForFile(FilePath file) {
        ViewInfo view = this.getViewByFile(file);
        return view != null && view.isUcm;
    }

    public void reloadViews() {
        TransparentVcs host = TransparentVcs.getInstance(this.myProject);
        ProjectLevelVcsManager mgr = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        CCaseConfig config = CCaseConfig.getInstance(this.myProject);
        VirtualFile[] roots = mgr.getRootsUnderVcs((AbstractVcs)host);
        try {
            this.loadAbsentViews(roots);
            this.removeObsoleteViews(roots);
            CCaseViewsManager.logViewsByName(this.viewsMapByRoot);
            if (CCaseSharedConfig.getInstance(this.myProject).isUseUcmModel()) {
                this.extractViewActivities();
                this.checkViewsWithoutActions();
                this.synchActivities2ChangeLists(null);
            }
        }
        catch (ClearCaseNoServerException e) {
            TransparentVcs.LOG.info((Throwable)e);
            String message = SERVER_UNAVAILABLE_MESSAGE + e.getMessage();
            AbstractVcsHelper.getInstance((Project)this.myProject).showError(new VcsException(message), ERRORS_TAB_NAME);
            config.setOfflineMode(true);
        }
        catch (ClearCaseException e) {
            TransparentVcs.LOG.info((Throwable)e);
            String message = FAILED_TO_INIT_VIEW_MESSAGE + e.getMessage();
            AbstractVcsHelper.getInstance((Project)this.myProject).showError(new VcsException(message), ERRORS_TAB_NAME);
        }
        catch (RuntimeException e) {
            TransparentVcs.LOG.info((Throwable)e);
            String message = FAILED_TO_COLLECT_VIEW_MESSAGE + e.getMessage();
            AbstractVcsHelper.getInstance((Project)this.myProject).showError(new VcsException(message, (Throwable)e), ERRORS_TAB_NAME);
            config.setOfflineMode(true);
        }
    }

    private void loadAbsentViews(VirtualFile[] roots) {
        for (VirtualFile root : roots) {
            if (this.viewsMapByRoot.containsKey(root.getPath())) continue;
            ViewInfo info = new ViewInfo();
            CCaseViewsManager.extractViewType(root.getPath(), info);
            this.viewsMapByRoot.put(root.getPath(), info);
        }
    }

    private void removeObsoleteViews(VirtualFile[] roots) {
        HashSet storedRoots = new HashSet(this.viewsMapByRoot.keySet());
        for (String storedRoot : storedRoots) {
            boolean isFound = false;
            for (VirtualFile root : roots) {
                if (!storedRoot.equals(root.getPath())) continue;
                isFound = true;
                break;
            }
            if (isFound) continue;
            this.viewsMapByRoot.remove(storedRoot);
        }
    }

    private static void extractViewType(String viewPath, ViewInfo info) throws ClearCaseNoServerException {
        String output = TransparentVcs.cleartoolOnLocalPathWithOutput(viewPath, LIST_VIEW_CMD, CURRENT_VIEW_SWITCH, LONG_SWITCH);
        if (TransparentVcs.isServerDownMessage(output)) {
            throw new ClearCaseNoServerException(output);
        }
        List lines = StringUtil.split((String)output, (String)"\n");
        for (String line : lines) {
            if (line.startsWith(TAG_SIG)) {
                info.tag = line.substring(TAG_SIG.length());
                int quoteIndex = info.tag.indexOf(34);
                if (quoteIndex == -1) continue;
                info.tag = info.tag.substring(0, quoteIndex - 1).trim();
                continue;
            }
            if (line.startsWith(TAG_UUID_SIG)) {
                info.uuid = line.substring(TAG_UUID_SIG.length());
                continue;
            }
            if (line.indexOf(ATTRIBUTES_SIG) == -1) continue;
            info.isSnapshot = line.indexOf(SNAPSHOT_SIG) != -1;
            info.isUcm = line.indexOf(UCM_SIG) != -1;
            break;
        }
    }

    private static void logViewsByName(HashMap<String, ViewInfo> views) {
        if (TransparentVcs.LOG.isDebugEnabled()) {
            TransparentVcs.LOG.debug(">>> Views list:");
            for (String root : views.keySet()) {
                TransparentVcs.LOG.debug("\t\t" + root + " -> " + views.get((Object)root).tag);
            }
        }
    }

    private void checkViewsWithoutActions() {
        HashSet passiveViews = new HashSet();
        for (ViewInfo info : this.viewsMapByRoot.values()) {
            if (info.currentActivity != null) continue;
            passiveViews.add(info.tag);
        }
        if (passiveViews.size() > 0) {
            ArrayList<VcsException> list = new ArrayList<VcsException>();
            for (String view : passiveViews) {
                VcsException warn = new VcsException("View " + view + " has no associated activity. Checkout from this view will be problematic.");
                warn.setIsWarning(true);
                list.add(warn);
            }
            AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(list, ERRORS_TAB_NAME);
        }
    }

    public void extractViewActivities() {
        if (CCaseConfig.getInstance(this.myProject).isOffline()) {
            return;
        }
        HashSet completedViews = new HashSet();
        this.activitiesMap.clear();
        for (ViewInfo info : this.viewsMapByRoot.values()) {
            String[] lines;
            if (!info.isUcm || completedViews.contains((Object)info.tag)) continue;
            String output = TransparentVcs.cleartoolWithOutput(LIST_ACTIVITY_CMD, ME_ONLY_SWITCH, OBSOLETE_SWITCH, VIEW_SWITCH, info.tag, FORMAT_SWITCH, LIST_ACTIVITY_FORMAT);
            if (TransparentVcs.isServerDownMessage(output)) {
                return;
            }
            completedViews.add((Object)info.tag);
            if (!StringUtil.isEmptyOrSpaces((String)output)) {
                TransparentVcs.LOG.debug(output);
            }
            info.currentActivity = null;
            for (String line : lines = LineTokenizer.tokenize((CharSequence)output, (boolean)false)) {
                ActivityInfo actInfo = CCaseViewsManager.parseActivities(line);
                if (actInfo == null) continue;
                this.activitiesMap.put(actInfo.name, actInfo);
                this.associateActivityWithView(actInfo);
            }
        }
        this.logActivities();
    }

    private void logActivities() {
        if (!TransparentVcs.LOG.isDebugEnabled()) {
            return;
        }
        TransparentVcs.LOG.debug(">>> Default Activities Detected:");
        for (String actName : this.activitiesMap.keySet()) {
            ActivityInfo actInfo = this.activitiesMap.get(actName);
            if (actInfo.activeInView == null) continue;
            TransparentVcs.LOG.debug(">>>\t\t[" + actName + "] -> [" + actInfo.activeInView + "]");
        }
        TransparentVcs.LOG.debug("\n>>> Extracted Activities:");
        for (ViewInfo info : this.viewsMapByRoot.values()) {
            if (!info.isUcm) continue;
            if (info.currentActivity != null) {
                TransparentVcs.LOG.debug(">>>\t" + info.tag + " -> " + info.currentActivity.publicName);
                continue;
            }
            TransparentVcs.LOG.debug(">>>\t" + info.tag + " has no default activity");
        }
    }

    public void synchActivities2ChangeLists(ChangeListManagerGate gate) {
        LocalChangeList nonDefltList = null;
        LocalChangeList defltListToDelete = null;
        ChangeListManager mgr = ChangeListManager.getInstance((Project)this.myProject);
        for (ActivityInfo info : this.activitiesMap.values()) {
            LocalChangeList list;
            LocalChangeList localChangeList = list = gate == null ? mgr.findChangeList(info.publicName) : gate.findChangeList(info.publicName);
            if (list != null) {
                if (info.isObsolete) {
                    if (!list.isDefault()) {
                        mgr.removeChangeList(list.getName());
                        continue;
                    }
                    defltListToDelete = list;
                    continue;
                }
                nonDefltList = list;
                continue;
            }
            if (info.isObsolete) continue;
            nonDefltList = gate == null ? mgr.addChangeList(info.publicName, null) : gate.addChangeList(info.publicName, null);
        }
        if (defltListToDelete != null && nonDefltList != null) {
            mgr.setDefaultChangeList(nonDefltList);
            mgr.removeChangeList(defltListToDelete.getName());
        }
    }

    public void checkChangedActivityForView(String fileName, String activityName) {
        ActivityInfo activity;
        ViewInfo view;
        VirtualFile file = VcsUtil.getVirtualFile((String)fileName);
        if (file != null && (view = this.getViewByFile(file)) != null && CCaseViewsManager.needToChangeActivity(view, activityName) && (activity = this.getActivityForName(activityName)) != null) {
            if (view.currentActivity != null) {
                view.currentActivity.activeInView = null;
            }
            view.currentActivity = activity;
            activity.activeInView = view.tag;
        }
    }

    private static boolean needToChangeActivity(ViewInfo view, String activityName) {
        return view.currentActivity == null || !view.currentActivity.publicName.equalsIgnoreCase(activityName);
    }

    @Nullable
    private static ActivityInfo parseActivities(String str) {
        ActivityInfo info = null;
        String[] tokens = str.split(FIELDS_DELIMITER);
        if (tokens.length == 4) {
            info = new ActivityInfo(tokens[0], tokens[2], tokens[1], tokens[3]);
        } else if (tokens.length == 3) {
            info = new ActivityInfo(tokens[0], tokens[2], tokens[1], null);
        }
        return info;
    }

    private void associateActivityWithView(@NotNull ActivityInfo activityInfo) {
        if (activityInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activityInfo", "net/sourceforge/transparent/CCaseViewsManager", "associateActivityWithView"));
        }
        if (activityInfo.activeInView != null) {
            for (ViewInfo view : this.viewsMapByRoot.values()) {
                if (!view.tag.equals(activityInfo.activeInView)) continue;
                view.currentActivity = activityInfo;
            }
        }
    }

    public void addFile2Changelist(String fileName, @NotNull String changeListName) {
        if (changeListName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeListName", "net/sourceforge/transparent/CCaseViewsManager", "addFile2Changelist"));
        }
        String normName = VcsUtil.getCanonicalLocalPath((String)fileName);
        this.activitiesAssociations.put(normName, changeListName);
    }

    public void removeFileFromActivity(String fileName) {
        fileName = VcsUtil.getCanonicalLocalPath((String)fileName);
        this.activitiesAssociations.remove(fileName);
    }

    @Nullable
    public String getCheckoutActivityForFile(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "net/sourceforge/transparent/CCaseViewsManager", "getCheckoutActivityForFile"));
        }
        return this.activitiesAssociations.get(fileName);
    }

    @Nullable
    public String getActivityDisplayName(String activity) {
        ActivityInfo info = this.activitiesMap.get(activity);
        return info != null ? info.publicName : null;
    }

    public String getActivityIdName(String activity) {
        for (ActivityInfo info : this.activitiesMap.values()) {
            if (!info.publicName.equals(activity)) continue;
            return info.name;
        }
        return activity.replaceAll("[ ()=]", "_");
    }

    @Nullable
    public String getActivityOfViewOfFile(FilePath path) {
        VirtualFile root = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)path);
        return root != null ? this.getActivityOfViewByRoot(root) : null;
    }

    @Nullable
    public String getActivityOfViewOfFile(VirtualFile file) {
        VirtualFile root = VcsUtil.getVcsRootFor((Project)this.myProject, (VirtualFile)file);
        return root != null ? this.getActivityOfViewByRoot(root) : null;
    }

    @Nullable
    public String getActivityOfViewByRoot(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "net/sourceforge/transparent/CCaseViewsManager", "getActivityOfViewByRoot"));
        }
        String activity = null;
        ViewInfo info = this.viewsMapByRoot.get(root.getPath());
        if (info != null && info.isUcm && info.currentActivity != null) {
            activity = info.currentActivity.publicName;
        }
        return activity;
    }

    public List<String> getDefaultActivities() {
        ArrayList<String> activities = new ArrayList<String>();
        for (ActivityInfo info : this.activitiesMap.values()) {
            if (info.activeInView == null) continue;
            activities.add(info.publicName);
        }
        return activities;
    }

    public void decorateChangeList(LocalChangeList changeList, @NonNls ColoredTreeCellRenderer cellRenderer, boolean selected, boolean expanded, boolean hasFocus) {
        if (ProjectLevelVcsManager.getInstance((Project)this.myProject).checkVcsIsActive(TransparentVcs.getKey().getName())) {
            ChangeListManagerImpl manager = ChangeListManagerImpl.getInstanceImpl((Project)this.myProject);
            TransparentVcs vcs = TransparentVcs.getInstance(this.myProject);
            boolean hasClearCaseChanges = changeList.getChanges().stream().anyMatch(change -> vcs == manager.getVcsFor(change));
            if (hasClearCaseChanges) {
                this.decorateClearCaseChangelist(changeList, cellRenderer);
            }
        }
    }

    private void decorateClearCaseChangelist(LocalChangeList changeList, ColoredTreeCellRenderer cellRenderer) {
        ActivityInfo info = this.getActivityForName(changeList.getName());
        if (info != null) {
            if (info.isLocked) {
                cellRenderer.append(LOCKED_ACTIVITY_SIG, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }
        } else {
            cellRenderer.append(NOT_ASSOCIATED_CHANGELIST_SIG, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        TransparentVcs.readRenamedElements(element, this.activitiesAssociations, PERSISTENCY_SAVED_ACTIVITY_MAP_TAG, false);
        List elements = element.getChildren(VIEW_INFO_TAG);
        for (Object cclObj : elements) {
            if (!(cclObj instanceof Element)) continue;
            ViewInfo info = new ViewInfo();
            info.tag = ((Element)cclObj).getChild(TAG_TAG).getValue();
            if (((Element)cclObj).getChild(UUID_TAG) != null) {
                info.uuid = ((Element)cclObj).getChild(UUID_TAG).getValue();
            }
            info.isUcm = Boolean.valueOf(((Element)cclObj).getChild(UCM_TAG).getValue());
            info.isSnapshot = Boolean.valueOf(((Element)cclObj).getChild(SNAPSHOT_TAG).getValue());
            String root = ((Element)cclObj).getChild(CONTENT_ROOT_TAG).getValue();
            this.viewsMapByRoot.put(root, info);
        }
        this.extractViewActivities();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        for (String root : this.viewsMapByRoot.keySet()) {
            ViewInfo info = this.viewsMapByRoot.get(root);
            Element listElement = new Element(VIEW_INFO_TAG);
            listElement.addContent(new Element(CONTENT_ROOT_TAG).addContent(root));
            listElement.addContent(new Element(TAG_TAG).addContent(info.tag));
            listElement.addContent(new Element(UUID_TAG).addContent(info.uuid));
            listElement.addContent(new Element(UCM_TAG).addContent(Boolean.toString(info.isUcm)));
            listElement.addContent(new Element(SNAPSHOT_TAG).addContent(Boolean.toString(info.isSnapshot)));
            if (info.currentActivity != null) {
                listElement.addContent(new Element(ACTIVITY_TAG).addContent(info.currentActivity.name));
            }
            element.addContent(listElement);
        }
        TransparentVcs.writePairedElement(element, this.activitiesAssociations, PERSISTENCY_SAVED_ACTIVITY_MAP_TAG);
    }

    public static class ActivityInfo {
        public String name;
        public String publicName;
        public boolean isObsolete;
        public boolean isLocked;
        public String activeInView;

        public ActivityInfo(@NotNull String actName, @NotNull String pubName, @NonNls @NotNull String isObs, String inView) {
            if (actName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actName", "net/sourceforge/transparent/CCaseViewsManager$ActivityInfo", "<init>"));
            }
            if (pubName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pubName", "net/sourceforge/transparent/CCaseViewsManager$ActivityInfo", "<init>"));
            }
            if (isObs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isObs", "net/sourceforge/transparent/CCaseViewsManager$ActivityInfo", "<init>"));
            }
            this.name = actName;
            this.publicName = pubName;
            this.isObsolete = isObs.equals("obsolete");
            this.isLocked = isObs.equals("locked");
            this.activeInView = inView == null ? null : inView.trim();
        }
    }

    public static class ViewInfo {
        public String tag;
        public String uuid;
        public boolean isSnapshot;
        public boolean isUcm;
        public ActivityInfo currentActivity;
    }
}

