/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.ChangeManagement;

import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VirtualFileFilter;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.transparent.ChangeManagement.CCaseChangeProvider;
import net.sourceforge.transparent.ChangeManagement.TransparentI;
import org.jetbrains.annotations.NotNull;

public class CCaseWriteableAndUnversionedCollector {
    private final Project myProject;
    private final TransparentI myTransparentI;
    private final Set<String> myFilesWritable;
    private final Set<String> myFilesIgnored;
    private final TreeSet<VirtualFile> myDirs;

    public CCaseWriteableAndUnversionedCollector(Project project, TransparentI transparentI) {
        this.myProject = project;
        this.myTransparentI = transparentI;
        this.myDirs = new TreeSet(FilePathComparator.getInstance());
        this.myFilesIgnored = new HashSet();
        this.myFilesWritable = new HashSet();
    }

    public Set<String> getFilesWritable() {
        return this.myFilesWritable;
    }

    public Set<String> getFilesIgnored() {
        return this.myFilesIgnored;
    }

    public TreeSet<VirtualFile> getDirs() {
        return this.myDirs;
    }

    public void collectWritableFiles(FilePath filePath) {
        VirtualFile vf = filePath.getVirtualFile();
        if (vf != null) {
            ArrayDeque chain = new ArrayDeque();
            HashMap chainROFlag = new HashMap();
            ProjectLevelVcsManager.getInstance((Project)this.myProject).iterateVcsRoot(vf, (Processor)new Processor<FilePath>((Map)chainROFlag, chain){
                final /* synthetic */ Map val$chainROFlag;
                final /* synthetic */ ArrayDeque val$chain;
                {
                    this.val$chainROFlag = map;
                    this.val$chain = arrayDeque;
                }

                public boolean process(FilePath file) {
                    String path = file.getPath().replace('\\', '/');
                    VirtualFile vFile = file.getVirtualFile();
                    if (vFile == null || !vFile.isValid()) {
                        return true;
                    }
                    if (CCaseWriteableAndUnversionedCollector.this.myTransparentI.isFileIgnored(vFile)) {
                        CCaseWriteableAndUnversionedCollector.this.myFilesIgnored.add(path);
                        return true;
                    }
                    if (CCaseChangeProvider.isValidFile(vFile)) {
                        CCaseWriteableAndUnversionedCollector.this.myFilesWritable.add(path);
                    } else if (!vFile.isDirectory()) {
                        if (!(Boolean.TRUE.equals(this.val$chainROFlag.get(vFile.getParent())) || vFile.isWritable() || CCaseWriteableAndUnversionedCollector.this.myTransparentI.isRenamedFile(vFile.getPath()))) {
                            this.val$chainROFlag.put(vFile.getParent(), true);
                        }
                    } else {
                        boolean versioned = CCaseWriteableAndUnversionedCollector.this.directoryIsVersioned(vFile);
                        if (!versioned) {
                            CCaseWriteableAndUnversionedCollector.this.myDirs.add(vFile);
                            this.val$chain.addFirst(vFile);
                        } else if (!Boolean.TRUE.equals(this.val$chainROFlag.get(vFile)) && !this.val$chain.isEmpty()) {
                            this.val$chainROFlag.put(vFile, true);
                        }
                    }
                    return true;
                }
            }, new VirtualFileFilter((Map)chainROFlag, chain){
                final /* synthetic */ Map val$chainROFlag;
                final /* synthetic */ ArrayDeque val$chain;
                {
                    this.val$chainROFlag = map;
                    this.val$chain = arrayDeque;
                }

                public boolean shouldGoIntoDirectory(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "net/sourceforge/transparent/ChangeManagement/CCaseWriteableAndUnversionedCollector$2", "shouldGoIntoDirectory"));
                    }
                    boolean ignored = CCaseWriteableAndUnversionedCollector.this.myTransparentI.isFileIgnored(file);
                    if (ignored) {
                        CCaseWriteableAndUnversionedCollector.this.myFilesIgnored.add(file.getPath());
                    }
                    return !ignored;
                }

                public void afterChildrenVisited(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "net/sourceforge/transparent/ChangeManagement/CCaseWriteableAndUnversionedCollector$2", "afterChildrenVisited"));
                    }
                    if (!file.isDirectory()) {
                        return;
                    }
                    Boolean ro = (Boolean)this.val$chainROFlag.get(file);
                    if (Boolean.TRUE.equals(ro)) {
                        CCaseWriteableAndUnversionedCollector.this.removeParentsFromUnversioned(file);
                    }
                    if (!this.val$chain.isEmpty() && ((VirtualFile)this.val$chain.getFirst()).equals(file)) {
                        this.val$chain.removeFirst();
                    }
                    this.val$chainROFlag.remove(file);
                }
            });
        }
    }

    private boolean directoryIsVersioned(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "net/sourceforge/transparent/ChangeManagement/CCaseWriteableAndUnversionedCollector", "directoryIsVersioned"));
        }
        String dirPath = virtualFile.getPath();
        return Boolean.TRUE.equals(virtualFile.getUserData(CCaseChangeProvider.ourVersionedKey)) || this.myTransparentI.isRenamedFolder(dirPath) || this.myTransparentI.isCheckedOutFolder(dirPath);
    }

    private void removeParentsFromUnversioned(VirtualFile vFile) {
        VirtualFile floor = this.myDirs.floor(vFile);
        if (floor == null) {
            return;
        }
        Iterator<VirtualFile> iterator = this.myDirs.headSet(floor, true).iterator();
        while (iterator.hasNext()) {
            VirtualFile next = iterator.next();
            if (!VfsUtil.isAncestor((VirtualFile)next, (VirtualFile)vFile, (boolean)false)) continue;
            iterator.remove();
        }
    }
}

