/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import net.sourceforge.transparent.CCaseViewsManager;
import net.sourceforge.transparent.TransparentVcs;
import net.sourceforge.transparent.actions.AsynchronousAction;
import org.jetbrains.annotations.NonNls;

public class DeliveryProjectAction
extends AsynchronousAction {
    @NonNls
    private static final String ACTION_NAME = "Deliver Activities";

    @Override
    protected String getActionName(AnActionEvent e) {
        return ACTION_NAME;
    }

    @Override
    public void perform(VirtualFile file, Project project) {
        VirtualFile[] roots;
        CCaseViewsManager viewsMgr = CCaseViewsManager.getInstance(project);
        ProjectLevelVcsManager mgr = ProjectLevelVcsManager.getInstance((Project)project);
        for (VirtualFile root : roots = mgr.getRootsUnderVcs((AbstractVcs)TransparentVcs.getInstance(project))) {
            if (!viewsMgr.isUcmViewForFile(root)) continue;
            String path = VcsUtil.getCanonicalPath((String)root.getPath());
            TransparentVcs.cleartoolOnLocalPath(path, "deliver", "-g");
            break;
        }
    }

    @Override
    protected boolean isEnabled(VirtualFile file, Project project) {
        boolean status = super.isEnabled(file, project);
        return status &= CCaseViewsManager.getInstance(project).isAnyUcmView();
    }
}

