/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class SpringBootModelConfigFileContributor {
    public static final ExtensionPointName<SpringBootModelConfigFileContributor> EP_NAME = ExtensionPointName.create((String)"com.intellij.spring.boot.modelConfigFileContributor");
    private static final Comparator<VirtualFile> VF_BY_NAME_COMPARATOR = (o1, o2) -> StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName());
    private static final boolean OUR_TEST_MODE = ApplicationManager.getApplication().isUnitTestMode();
    private final FileType myFileType;

    protected SpringBootModelConfigFileContributor(FileType fileType) {
        this.myFileType = fileType;
    }

    public List<VirtualFile> getConfigurationFiles(Module module) {
        SmartList allConfigFiles = new SmartList();
        allConfigFiles.addAll(this.findApplicationConfigFiles(module, "application"));
        allConfigFiles.addAll(this.findApplicationConfigFiles(module, "bootstrap"));
        return allConfigFiles;
    }

    private List<VirtualFile> findApplicationConfigFiles(Module module, String baseName) {
        VirtualFile configFile = this.findSingleConfigFile(module, baseName);
        if (configFile == null) {
            return Collections.emptyList();
        }
        return this.collectProfileConfigs(module, configFile);
    }

    @Nullable
    private VirtualFile findSingleConfigFile(Module module, String fileNameWithoutExtension) {
        GlobalSearchScope configFileSearchScope = SpringBootModelConfigFileContributor.getConfigFileSearchScope(module);
        if (configFileSearchScope == null) {
            return null;
        }
        Collection allFiles = FileTypeIndex.getFiles((FileType)this.myFileType, (GlobalSearchScope)configFileSearchScope);
        List matchingFiles = ContainerUtil.filter((Collection)allFiles, file -> Comparing.equal((String)fileNameWithoutExtension, (String)file.getNameWithoutExtension()));
        return matchingFiles.size() == 1 ? (VirtualFile)ContainerUtil.getFirstItem((List)matchingFiles) : null;
    }

    @Nullable
    private static GlobalSearchScope getConfigFileSearchScope(Module module) {
        if (OUR_TEST_MODE) {
            return module.getModuleScope(false);
        }
        if (module.isDisposed()) {
            return null;
        }
        List resourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
        if (resourceRoots.isEmpty()) {
            return null;
        }
        return GlobalSearchScopesCore.directoriesScope((Project)module.getProject(), (boolean)true, (VirtualFile[])resourceRoots.toArray(new VirtualFile[resourceRoots.size()]));
    }

    private List<VirtualFile> collectProfileConfigs(Module module, VirtualFile configFile) {
        SmartList result = new SmartList((Object)configFile);
        VirtualFile parentDirectory = configFile.getParent();
        if (parentDirectory == null) {
            return result;
        }
        String fileNamePrefix = configFile.getNameWithoutExtension() + '-';
        Project project = module.getProject();
        GlobalSearchScope directoryScope = GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)parentDirectory, (boolean)false);
        Collection allByTypeInDirectory = FileTypeIndex.getFiles((FileType)this.myFileType, (GlobalSearchScope)directoryScope);
        List matching = ContainerUtil.filter((Collection)allByTypeInDirectory, file -> StringUtil.startsWith((CharSequence)file.getNameWithoutExtension(), (CharSequence)fileNamePrefix));
        Collections.sort(matching, VF_BY_NAME_COMPARATOR);
        result.addAll(matching);
        return result;
    }
}

