/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit5;

import com.intellij.junit4.ExpectedPatterns;
import com.intellij.rt.execution.junit.ComparisonFailureData;
import com.intellij.rt.execution.junit.MapSerializerUtil;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.Set;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.MultipleFailuresError;
import org.opentest4j.ValueWrapper;

public class JUnit5TestExecutionListener
implements TestExecutionListener {
    private final PrintStream myPrintStream;
    private TestPlan myTestPlan;
    private long myCurrentTestStart;
    private int myFinishCount;
    private String myRootName;
    private Set<TestIdentifier> myRoots;
    private boolean mySuccessful;

    public JUnit5TestExecutionListener() {
        this(System.out);
    }

    public JUnit5TestExecutionListener(PrintStream printStream) {
        this.myPrintStream = printStream;
        this.myPrintStream.println("##teamcity[enteredTheMatrix]");
    }

    public boolean wasSuccessful() {
        return this.mySuccessful;
    }

    public void initialize() {
        this.mySuccessful = true;
        this.myFinishCount = 0;
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        StringBuilder builder = new StringBuilder();
        builder.append("timestamp = ").append(entry.getTimestamp());
        entry.getKeyValuePairs().forEach((key, value) -> builder.append(", ").append((String)key).append(" = ").append((String)value));
        this.myPrintStream.println(builder.toString());
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        if (this.myRootName != null) {
            int lastPointIdx = this.myRootName.lastIndexOf(46);
            String name = this.myRootName;
            String comment = null;
            if (lastPointIdx >= 0) {
                name = this.myRootName.substring(lastPointIdx + 1);
                comment = this.myRootName.substring(0, lastPointIdx);
            }
            this.myPrintStream.println("##teamcity[rootName name = '" + JUnit5TestExecutionListener.escapeName(name) + (comment != null ? "' comment = '" + JUnit5TestExecutionListener.escapeName(comment) : "") + "' location = 'java:suite://" + JUnit5TestExecutionListener.escapeName(this.myRootName) + "']");
        }
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.myTestPlan = null;
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.executionStarted(testIdentifier);
        this.executionFinished(testIdentifier, TestExecutionResult.Status.ABORTED, null, reason);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (testIdentifier.isTest()) {
            this.testStarted(testIdentifier);
            this.myCurrentTestStart = System.currentTimeMillis();
        } else if (!this.myRoots.contains(testIdentifier)) {
            this.myFinishCount = 0;
            this.myPrintStream.println("##teamcity[testSuiteStarted" + JUnit5TestExecutionListener.idAndName(testIdentifier) + "']");
        }
    }

    private static String idAndName(TestIdentifier testIdentifier) {
        return JUnit5TestExecutionListener.idAndName(testIdentifier, testIdentifier.getDisplayName());
    }

    private static String idAndName(TestIdentifier testIdentifier, String displayName) {
        return " id='" + testIdentifier.getUniqueId().toString() + "' name='" + JUnit5TestExecutionListener.escapeName(displayName);
    }

    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
        boolean i = false;
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        TestExecutionResult.Status status = testExecutionResult.getStatus();
        Throwable throwableOptional = testExecutionResult.getThrowable().orElse(null);
        this.executionFinished(testIdentifier, status, throwableOptional, null);
        this.mySuccessful &= TestExecutionResult.Status.SUCCESSFUL == testExecutionResult.getStatus();
    }

    private void executionFinished(TestIdentifier testIdentifier, TestExecutionResult.Status status, Throwable throwableOptional, String reason) {
        String displayName = testIdentifier.getDisplayName();
        if (testIdentifier.isTest()) {
            long duration = this.getDuration();
            if (status == TestExecutionResult.Status.FAILED) {
                this.testFailure(testIdentifier, "testFailed", throwableOptional, duration, reason, true);
            } else if (status == TestExecutionResult.Status.ABORTED) {
                this.testFailure(testIdentifier, "testIgnored", throwableOptional, duration, reason, true);
            }
            this.testFinished(testIdentifier, duration);
            ++this.myFinishCount;
        } else if (!this.myRoots.contains(testIdentifier)) {
            String messageName = null;
            if (status == TestExecutionResult.Status.FAILED) {
                messageName = "testFailed";
            } else if (status == TestExecutionResult.Status.ABORTED) {
                messageName = "testIgnored";
            }
            if (messageName != null) {
                Set descendants;
                if (status == TestExecutionResult.Status.FAILED) {
                    this.myPrintStream.println("\n##teamcity[testStarted name='Class Configuration']");
                    this.testFailure("Class Configuration", "Class Configuration", messageName, throwableOptional, 0L, reason, true);
                    this.myPrintStream.println("\n##teamcity[testFinished name='Class Configuration']");
                }
                if (!(descendants = this.myTestPlan.getDescendants(testIdentifier)).isEmpty() && this.myFinishCount == 0) {
                    for (TestIdentifier childIdentifier : descendants) {
                        this.testStarted(childIdentifier);
                        this.testFailure(childIdentifier, "testIgnored", status == TestExecutionResult.Status.ABORTED ? throwableOptional : null, 0L, reason, status == TestExecutionResult.Status.ABORTED);
                        this.testFinished(childIdentifier, 0L);
                    }
                }
            }
            this.myPrintStream.println("##teamcity[testSuiteFinished " + JUnit5TestExecutionListener.idAndName(testIdentifier, displayName) + "']");
        }
    }

    protected long getDuration() {
        return System.currentTimeMillis() - this.myCurrentTestStart;
    }

    private void testStarted(TestIdentifier testIdentifier) {
        this.myPrintStream.println("\n##teamcity[testStarted" + JUnit5TestExecutionListener.idAndName(testIdentifier) + this.getLocationHint(testIdentifier) + "']");
    }

    private void testFinished(TestIdentifier testIdentifier, long duration) {
        this.myPrintStream.println("\n##teamcity[testFinished" + JUnit5TestExecutionListener.idAndName(testIdentifier) + (duration > 0L ? "' duration='" + Long.toString(duration) : "") + "']");
    }

    private void testFailure(TestIdentifier testIdentifier, String messageName, Throwable ex, long duration, String reason, boolean includeThrowable) {
        this.testFailure(testIdentifier.getDisplayName(), testIdentifier.getUniqueId().toString(), messageName, ex, duration, reason, includeThrowable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFailure(String methodName, String id, String messageName, Throwable ex, long duration, String reason, boolean includeThrowable) {
        block14: {
            LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
            attrs.put("name", methodName);
            attrs.put("id", id);
            if (duration > 0L) {
                attrs.put("duration", Long.toString(duration));
            }
            if (reason != null) {
                attrs.put("message", reason);
            }
            try {
                if (ex == null) break block14;
                ComparisonFailureData failureData = null;
                if (ex instanceof MultipleFailuresError && ((MultipleFailuresError)ex).hasFailures()) {
                    for (AssertionError assertionError : ((MultipleFailuresError)ex).getFailures()) {
                        this.testFailure(methodName, id, messageName, (Throwable)((Object)assertionError), duration, reason, false);
                    }
                } else if (ex instanceof AssertionFailedError && ((AssertionFailedError)ex).isActualDefined() && ((AssertionFailedError)ex).isExpectedDefined()) {
                    ValueWrapper actual = ((AssertionFailedError)ex).getActual();
                    ValueWrapper expected = ((AssertionFailedError)ex).getExpected();
                    failureData = new ComparisonFailureData(expected.getStringRepresentation(), actual.getStringRepresentation());
                } else {
                    try {
                        failureData = ExpectedPatterns.createExceptionNotification((Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (includeThrowable || failureData == null) {
                    ComparisonFailureData.registerSMAttributes((ComparisonFailureData)failureData, (String)this.getTrace(ex), (String)ex.getMessage(), attrs, (Throwable)ex);
                } else {
                    ComparisonFailureData.registerSMAttributes((ComparisonFailureData)failureData, (String)"", (String)"", attrs, (Throwable)ex, (String)"");
                }
            }
            finally {
                this.myPrintStream.println("\n" + MapSerializerUtil.asString((String)messageName, attrs));
            }
        }
    }

    protected String getTrace(Throwable ex) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        ex.printStackTrace(writer);
        return stringWriter.toString();
    }

    public void sendTree(TestPlan testPlan, String rootName) {
        this.myTestPlan = testPlan;
        this.myRootName = rootName;
        this.myRoots = testPlan.getRoots();
        for (TestIdentifier root : this.myRoots) {
            assert (root.isContainer());
            for (TestIdentifier testIdentifier : testPlan.getChildren(root)) {
                this.sendTreeUnderRoot(testPlan, testIdentifier);
            }
        }
        this.myPrintStream.println("##teamcity[treeEnded]");
    }

    private void sendTreeUnderRoot(TestPlan testPlan, TestIdentifier root) {
        String idAndName = JUnit5TestExecutionListener.idAndName(root);
        if (root.isContainer()) {
            this.myPrintStream.println("##teamcity[suiteTreeStarted" + idAndName + this.getLocationHint(root) + "']");
            for (TestIdentifier childIdentifier : testPlan.getChildren(root)) {
                this.sendTreeUnderRoot(testPlan, childIdentifier);
            }
            this.myPrintStream.println("##teamcity[suiteTreeEnded" + idAndName + "']");
        } else if (root.isTest()) {
            this.myPrintStream.println("##teamcity[suiteTreeNode " + idAndName + this.getLocationHint(root) + "']");
        }
    }

    private String getLocationHint(TestIdentifier root) {
        String className = JUnit5TestExecutionListener.getClassName(root);
        String methodName = JUnit5TestExecutionListener.getMethodName(root);
        return "' locationHint='java:" + (root.isTest() ? "test" : "suite") + "://" + JUnit5TestExecutionListener.escapeName(className + (methodName != null ? "." + methodName : ""));
    }

    private static String escapeName(String str) {
        return MapSerializerUtil.escapeStr((String)str, (MapSerializerUtil.EscapeInfoProvider)MapSerializerUtil.STD_ESCAPER);
    }

    static String getClassName(TestIdentifier description) {
        return description.getSource().map(source -> {
            if (source instanceof MethodSource) {
                return ((MethodSource)source).getClassName();
            }
            if (source instanceof ClassSource) {
                return ((ClassSource)source).getClassName();
            }
            return null;
        }).orElse(null);
    }

    static String getMethodName(TestIdentifier testIdentifier) {
        return testIdentifier.getSource().map(source -> {
            if (source instanceof MethodSource) {
                return ((MethodSource)source).getMethodName();
            }
            return null;
        }).orElse(null);
    }
}

