/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.graph.dnd;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.graph.builder.dnd.GraphDnDSupport;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.seam.graph.PageflowDataModel;
import com.intellij.seam.graph.PageflowNode;
import com.intellij.seam.graph.PageflowNodeType;
import com.intellij.seam.graph.impl.DecisionNode;
import com.intellij.seam.graph.impl.EndStateNode;
import com.intellij.seam.graph.impl.PageNode;
import com.intellij.seam.graph.impl.ProcessStateNode;
import com.intellij.seam.graph.impl.StartStateNode;
import com.intellij.seam.model.xml.pageflow.Decision;
import com.intellij.seam.model.xml.pageflow.EndState;
import com.intellij.seam.model.xml.pageflow.Page;
import com.intellij.seam.model.xml.pageflow.PageflowDefinition;
import com.intellij.seam.model.xml.pageflow.ProcessState;
import com.intellij.seam.model.xml.pageflow.StartPage;
import com.intellij.seam.model.xml.pageflow.StartState;
import com.intellij.util.Function;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import icons.SeamPageflowIcons;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PageflowDnDSupport
implements GraphDnDSupport<PageflowNode, PageflowNodeType> {
    private final PageflowDataModel myDataModel;
    private static final String UNKNOWN = "unknown";

    public PageflowDnDSupport(PageflowDataModel dataModel) {
        this.myDataModel = dataModel;
    }

    public Map<PageflowNodeType, Pair<String, Icon>> getDnDActions() {
        LinkedHashMap<PageflowNodeType, Pair<String, Icon>> nodes = new LinkedHashMap<PageflowNodeType, Pair<String, Icon>>();
        nodes.put(PageflowNodeType.START_STATE, Pair.create((Object)"Start State", (Object)SeamPageflowIcons.Start));
        nodes.put(PageflowNodeType.START_PAGE, Pair.create((Object)"Start Page", (Object)SeamPageflowIcons.StartPage));
        nodes.put(PageflowNodeType.PAGE, Pair.create((Object)"Page", (Object)SeamPageflowIcons.Page));
        nodes.put(PageflowNodeType.DECISIION, Pair.create((Object)"Decision", (Object)SeamPageflowIcons.Decision));
        nodes.put(PageflowNodeType.PROCESS_STATE, Pair.create((Object)"Process State", (Object)SeamPageflowIcons.ProcessState));
        nodes.put(PageflowNodeType.END_STATE, Pair.create((Object)"End State", (Object)SeamPageflowIcons.End));
        return nodes;
    }

    public boolean canStartDragging(PageflowNodeType pageflowNodeType) {
        PageflowDefinition pageflowDefinition = this.getDataModel().getPageflowDefinition();
        if (pageflowDefinition != null) {
            if (pageflowNodeType == PageflowNodeType.START_STATE) {
                return !DomUtil.hasXml((DomElement)pageflowDefinition.getStartState());
            }
            if (pageflowNodeType == PageflowNodeType.START_PAGE) {
                return !DomUtil.hasXml((DomElement)pageflowDefinition.getStartPage());
            }
        }
        return true;
    }

    public PageflowNode drop(PageflowNodeType pageflowNodeType) {
        PageflowDefinition pageflowDefinition = this.getDataModel().getPageflowDefinition();
        if (pageflowNodeType == PageflowNodeType.PAGE) {
            return PageflowDnDSupport.startInWCA(this.getDataModel().getProject(), pageflowDefinition, PageflowDnDSupport.getDropPageFunction());
        }
        switch (pageflowNodeType) {
            case PAGE: {
                return PageflowDnDSupport.startInWCA(this.getDataModel().getProject(), pageflowDefinition, PageflowDnDSupport.getDropPageFunction());
            }
            case DECISIION: {
                return PageflowDnDSupport.startInWCA(this.getDataModel().getProject(), pageflowDefinition, PageflowDnDSupport.getDropDecisionFunction());
            }
            case END_PAGE: {
                break;
            }
            case START_PAGE: {
                return PageflowDnDSupport.startInWCA(this.getDataModel().getProject(), pageflowDefinition, PageflowDnDSupport.getDropStartPageFunction());
            }
            case START_STATE: {
                return PageflowDnDSupport.startInWCA(this.getDataModel().getProject(), pageflowDefinition, PageflowDnDSupport.getDropStartStateFunction());
            }
            case PROCESS_STATE: {
                return PageflowDnDSupport.startInWCA(this.getDataModel().getProject(), pageflowDefinition, PageflowDnDSupport.getDropProcessStateFunction());
            }
            case END_STATE: {
                return PageflowDnDSupport.startInWCA(this.getDataModel().getProject(), pageflowDefinition, PageflowDnDSupport.getDropEndStateFunction());
            }
        }
        return null;
    }

    private static Function<PageflowDefinition, PageflowNode> getDropEndStateFunction() {
        return pageflowDefinition -> {
            EndState endState = pageflowDefinition.addEndState();
            endState.getName().setStringValue(UNKNOWN);
            return new EndStateNode(UNKNOWN, (EndState)endState.createStableCopy());
        };
    }

    private static Function<PageflowDefinition, PageflowNode> getDropStartStateFunction() {
        return pageflowDefinition -> {
            StartState startState = pageflowDefinition.getStartState();
            startState.getName().setStringValue(UNKNOWN);
            return new StartStateNode(UNKNOWN, (StartState)startState.createStableCopy());
        };
    }

    private static Function<PageflowDefinition, PageflowNode> getDropStartPageFunction() {
        return pageflowDefinition -> {
            StartPage startPage = pageflowDefinition.getStartPage();
            startPage.getName().setStringValue(UNKNOWN);
            return new PageNode(UNKNOWN, (StartPage)startPage.createStableCopy());
        };
    }

    private static Function<PageflowDefinition, PageflowNode> getDropProcessStateFunction() {
        return pageflowDefinition -> {
            ProcessState processState = pageflowDefinition.addProcessState();
            processState.getName().setStringValue(UNKNOWN);
            return new ProcessStateNode(UNKNOWN, (ProcessState)processState.createStableCopy());
        };
    }

    private static Function<PageflowDefinition, PageflowNode> getDropPageFunction() {
        return pageflowDefinition -> {
            Page page = pageflowDefinition.addPage();
            page.getName().setStringValue(UNKNOWN);
            return new PageNode(UNKNOWN, (Page)page.createStableCopy());
        };
    }

    private static Function<PageflowDefinition, PageflowNode> getDropDecisionFunction() {
        return pageflowDefinition -> {
            Decision decision = pageflowDefinition.addDecision();
            decision.getName().setStringValue(UNKNOWN);
            return new DecisionNode(UNKNOWN, (Decision)decision.createStableCopy());
        };
    }

    private static PageflowNode startInWCA(Project project, final PageflowDefinition pageflowDefinition, final Function<PageflowDefinition, PageflowNode> function) {
        return (PageflowNode)new WriteCommandAction<PageflowNode>(project, new PsiFile[]{DomUtil.getFile((DomElement)pageflowDefinition)}){

            protected void run(@NotNull Result<PageflowNode> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/seam/graph/dnd/PageflowDnDSupport$1", "run"));
                }
                result.setResult(function.fun((Object)pageflowDefinition));
            }
        }.execute().getResultObject();
    }

    public PageflowDataModel getDataModel() {
        return this.myDataModel;
    }

    public List<String> getExistedNodesNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (PageflowNode node : this.myDataModel.getNodes(false)) {
            String s = node.getName();
            if (StringUtil.isEmptyOrSpaces((String)s)) continue;
            names.add(s);
        }
        return names;
    }
}

