/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudfoundry.agent.cloud;

import com.intellij.javaee.cloudfoundry.agent.base.cloud.CFCloudAgentApplicationBase;
import com.intellij.javaee.cloudfoundry.agent.base.cloud.CFCloudAgentDeploymentBase;
import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgentApplicationV1Impl;
import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgentDeploymentConfiguration;
import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgentV1Impl;
import com.intellij.javaee.cloudfoundry.agent.service.CFAppServices;
import com.intellij.javaee.cloudfoundry.agent.settings.CFAppSettings;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.client.lib.CloudFoundryClient;

public class CFCloudAgentDeploymentV1Impl
extends CFCloudAgentDeploymentBase {
    private static final Map<String, String> ourAppTypes = new HashMap<String, String>();
    private final CloudFoundryClient myClient;

    public CFCloudAgentDeploymentV1Impl(CFCloudAgentV1Impl agent, CloudFoundryClient client, CFCloudAgentDeploymentConfiguration config) {
        super((CFCloudAgentApplicationBase)new CFCloudAgentApplicationV1Impl(agent, client, config.getDeploymentName()), config);
        this.myClient = client;
    }

    protected void doDeploy() throws IOException {
        CFCloudAgentDeploymentConfiguration config = this.getConfig();
        String deploymentName = this.getDeploymentName();
        List serviceNames = null;
        List<String> uris = Arrays.asList(config.getAppUrls());
        String appType = ourAppTypes.get(config.getAppType());
        String infra = config.getInfra();
        this.myClient.createApplication(deploymentName, appType, this.myClient.getDefaultApplicationMemory(appType), uris, serviceNames, infra);
        this.myClient.uploadApplication(deploymentName, config.getFile().getCanonicalPath());
        this.setAppSettings(config.getApplicationSettings());
        this.setAppServices(config.getApplicationServices());
        this.doStart();
    }

    private void doStart() {
        this.myClient.startApplication(this.getDeploymentName());
    }

    private void setAppSettings(CFAppSettings settings) {
        String deploymentName = this.getDeploymentName();
        Integer memory = settings.getMemory();
        Integer instances = settings.getInstances();
        if (memory != null) {
            this.myClient.updateApplicationMemory(deploymentName, memory.intValue());
        }
        if (instances != null) {
            this.myClient.updateApplicationInstances(deploymentName, instances.intValue());
        }
    }

    private void setAppServices(CFAppServices services) {
        if (services != null) {
            this.myClient.updateApplicationServices(this.getDeploymentName(), services.getServiceNames());
        }
    }

    static {
        ourAppTypes.put("java.web", "java_web/1.0");
        ourAppTypes.put("spring.Web", "spring_web/1.0");
        ourAppTypes.put("grails", "grails/1.0");
        ourAppTypes.put("standalone", "standalone");
    }
}

