/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class AndroidAutoDetector
extends ResourceXmlDetector
implements Detector.XmlScanner,
Detector.JavaPsiScanner {
    public static final Implementation IMPL = new Implementation(AndroidAutoDetector.class, EnumSet.of(Scope.RESOURCE_FILE, Scope.MANIFEST, Scope.JAVA_FILE), Scope.RESOURCE_FILE_SCOPE);
    public static final Issue INVALID_USES_TAG_ISSUE = Issue.create("InvalidUsesTagAttribute", "Invalid `name` attribute for `uses` element.", "The <uses> element in `<automotiveApp>` should contain a valid value for the `name` attribute.\nValid values are `media` or `notification`.", Category.CORRECTNESS, 6, Severity.ERROR, IMPL).addMoreInfo("https://developer.android.com/training/auto/start/index.html#auto-metadata");
    public static final Issue MISSING_MEDIA_BROWSER_SERVICE_ACTION_ISSUE = Issue.create("MissingMediaBrowserServiceIntentFilter", "Missing intent-filter with action `android.media.browse.MediaBrowserService`.", "An Automotive Media App requires an exported service that extends `android.service.media.MediaBrowserService` with an `intent-filter` for the action `android.media.browse.MediaBrowserService` to be able to browse and play media.\nTo do this, add\n`<intent-filter>`\n    `<action android:name=\"android.media.browse.MediaBrowserService\" />`\n`</intent-filter>`\n to the service that extends `android.service.media.MediaBrowserService`", Category.CORRECTNESS, 6, Severity.ERROR, IMPL).addMoreInfo("https://developer.android.com/training/auto/audio/index.html#config_manifest");
    public static final Issue MISSING_INTENT_FILTER_FOR_MEDIA_SEARCH = Issue.create("MissingIntentFilterForMediaSearch", "Missing intent-filter with action `android.media.action.MEDIA_PLAY_FROM_SEARCH`", "To support voice searches on Android Auto, you should also register an `intent-filter` for the action `android.media.action.MEDIA_PLAY_FROM_SEARCH`.\nTo do this, add\n`<intent-filter>`\n    `<action android:name=\"android.media.action.MEDIA_PLAY_FROM_SEARCH\" />`\n`</intent-filter>`\nto your `<activity>` or `<service>`.", Category.CORRECTNESS, 6, Severity.ERROR, IMPL).addMoreInfo("https://developer.android.com/training/auto/audio/index.html#support_voice");
    public static final Issue MISSING_ON_PLAY_FROM_SEARCH = Issue.create("MissingOnPlayFromSearch", "Missing `onPlayFromSearch`.", "To support voice searches on Android Auto, in addition to adding an `intent-filter` for the action `onPlayFromSearch`, you also need to override and implement `onPlayFromSearch(String query, Bundle bundle)`", Category.CORRECTNESS, 6, Severity.ERROR, IMPL).addMoreInfo("https://developer.android.com/training/auto/audio/index.html#support_voice");
    private static final String CAR_APPLICATION_METADATA_NAME = "com.google.android.gms.car.application";
    private static final String VAL_NAME_MEDIA = "media";
    private static final String VAL_NAME_NOTIFICATION = "notification";
    private static final String TAG_AUTOMOTIVE_APP = "automotiveApp";
    private static final String ATTR_RESOURCE = "resource";
    private static final String TAG_USES = "uses";
    private static final String ACTION_MEDIA_BROWSER_SERVICE = "android.media.browse.MediaBrowserService";
    private static final String ACTION_MEDIA_PLAY_FROM_SEARCH = "android.media.action.MEDIA_PLAY_FROM_SEARCH";
    private static final String CLASS_MEDIA_SESSION_CALLBACK = "android.media.session.MediaSession.Callback";
    private static final String CLASS_V4MEDIA_SESSION_COMPAT_CALLBACK = "android.support.v4.media.session.MediaSessionCompat.Callback";
    private static final String METHOD_MEDIA_SESSION_PLAY_FROM_SEARCH = "onPlayFromSearch";
    private static final String BUNDLE_ARG = "android.os.Bundle";
    private boolean mDoAutomotiveAppCheck;
    private boolean mMediaIntentFilterFound;
    private boolean mMediaSearchIntentFilterFound;
    private String mAutomotiveResourceFileName;
    private boolean mIsAutomotiveMediaApp;
    private Location.Handle mMainApplicationHandle;

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.XML;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList(TAG_AUTOMOTIVE_APP, "meta-data", "service", "intent-filter", "application");
    }

    @Override
    public void beforeCheckProject(Context context) {
        this.mIsAutomotiveMediaApp = false;
        this.mAutomotiveResourceFileName = null;
        this.mMediaIntentFilterFound = false;
        this.mMediaSearchIntentFilterFound = false;
    }

    @Override
    public void visitElement(XmlContext context, Element element) {
        String tagName = element.getTagName();
        if ("meta-data".equals(tagName) && !this.mDoAutomotiveAppCheck) {
            this.checkAutoMetadataTag(element);
        } else if (TAG_AUTOMOTIVE_APP.equals(tagName)) {
            this.checkAutomotiveAppElement(context, element);
        } else if ("application".equals(tagName)) {
            if (context.getMainProject() == context.getProject() && !context.getProject().isLibrary()) {
                this.mMainApplicationHandle = context.createLocationHandle(element);
                this.mMainApplicationHandle.setClientData(element);
            }
        } else if ("service".equals(tagName)) {
            this.checkServiceForBrowserServiceIntentFilter(element);
        } else if ("intent-filter".equals(tagName)) {
            this.checkForMediaSearchIntentFilter(element);
        }
    }

    private void checkAutoMetadataTag(Element element) {
        String autoFileName;
        String name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if (CAR_APPLICATION_METADATA_NAME.equals(name) && (autoFileName = element.getAttributeNS("http://schemas.android.com/apk/res/android", ATTR_RESOURCE)) != null && autoFileName.startsWith("@xml/")) {
            this.mDoAutomotiveAppCheck = true;
            this.mAutomotiveResourceFileName = autoFileName.substring("@xml/".length()) + ".xml";
        }
    }

    private void checkAutomotiveAppElement(XmlContext context, Element element) {
        boolean isMetadataResource = this.mAutomotiveResourceFileName != null && this.mAutomotiveResourceFileName.equals(context.file.getName());
        for (Element child : LintUtils.getChildren(element)) {
            Attr node;
            if (!TAG_USES.equals(child.getTagName())) continue;
            String attrValue = child.getAttribute("name");
            if (VAL_NAME_MEDIA.equals(attrValue)) {
                this.mIsAutomotiveMediaApp |= isMetadataResource;
                continue;
            }
            if (VAL_NAME_NOTIFICATION.equals(attrValue) || !context.isEnabled(INVALID_USES_TAG_ISSUE) || (node = child.getAttributeNode("name")) == null) continue;
            context.report(INVALID_USES_TAG_ISSUE, node, context.getLocation(node), "Expecting one of `media` or `notification` for the name attribute in uses tag.");
        }
        if (this.mIsAutomotiveMediaApp && !context.getProject().isLibrary() && this.mMainApplicationHandle != null && this.mDoAutomotiveAppCheck) {
            Element node = (Element)this.mMainApplicationHandle.getClientData();
            if (!this.mMediaIntentFilterFound && context.isEnabled(MISSING_MEDIA_BROWSER_SERVICE_ACTION_ISSUE)) {
                context.report(MISSING_MEDIA_BROWSER_SERVICE_ACTION_ISSUE, node, this.mMainApplicationHandle.resolve(), "Missing `intent-filter` for action `android.media.browse.MediaBrowserService` that is required for android auto support");
            }
            if (!this.mMediaSearchIntentFilterFound && context.isEnabled(MISSING_INTENT_FILTER_FOR_MEDIA_SEARCH)) {
                context.report(MISSING_INTENT_FILTER_FOR_MEDIA_SEARCH, node, this.mMainApplicationHandle.resolve(), "Missing `intent-filter` for action `android.media.action.MEDIA_PLAY_FROM_SEARCH`.");
            }
        }
    }

    private void checkServiceForBrowserServiceIntentFilter(Element element) {
        if ("service".equals(element.getTagName()) && !this.mMediaIntentFilterFound) {
            for (Element child : LintUtils.getChildren(element)) {
                String tagName = child.getTagName();
                if (!"intent-filter".equals(tagName)) continue;
                for (Element filterChild : LintUtils.getChildren(child)) {
                    String actionValue;
                    if (!"action".equals(filterChild.getTagName()) || !ACTION_MEDIA_BROWSER_SERVICE.equals(actionValue = filterChild.getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
                    this.mMediaIntentFilterFound = true;
                    return;
                }
            }
        }
    }

    private void checkForMediaSearchIntentFilter(Element element) {
        if (!this.mMediaSearchIntentFilterFound) {
            for (Element filterChild : LintUtils.getChildren(element)) {
                String actionValue;
                if (!"action".equals(filterChild.getTagName()) || !ACTION_MEDIA_PLAY_FROM_SEARCH.equals(actionValue = filterChild.getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
                this.mMediaSearchIntentFilterFound = true;
                break;
            }
        }
    }

    @Override
    public List<String> applicableSuperClasses() {
        return this.mIsAutomotiveMediaApp ? Arrays.asList(CLASS_MEDIA_SESSION_CALLBACK, CLASS_V4MEDIA_SESSION_COMPAT_CALLBACK) : null;
    }

    @Override
    public void checkClass(JavaContext context, PsiClass declaration) {
        if (!context.getEvaluator().isAbstract((PsiModifierListOwner)declaration)) {
            MediaSessionCallbackVisitor visitor = new MediaSessionCallbackVisitor(context);
            declaration.accept((PsiElementVisitor)visitor);
            if (!visitor.isPlayFromSearchMethodFound() && context.isEnabled(MISSING_ON_PLAY_FROM_SEARCH)) {
                context.report(MISSING_ON_PLAY_FROM_SEARCH, (PsiElement)declaration, context.getNameLocation((PsiElement)declaration), "This class does not override `onPlayFromSearch` from `MediaSession.Callback` The method should be overridden and implemented to support Voice search on Android Auto.");
            }
        }
    }

    public static String[] getAllowedAutomotiveAppTypes() {
        return new String[]{VAL_NAME_MEDIA, VAL_NAME_NOTIFICATION};
    }

    private static class MediaSessionCallbackVisitor
    extends JavaRecursiveElementVisitor {
        private final JavaContext mContext;
        private boolean mOnPlayFromSearchFound;

        public MediaSessionCallbackVisitor(JavaContext context) {
            this.mContext = context;
        }

        public boolean isPlayFromSearchMethodFound() {
            return this.mOnPlayFromSearchFound;
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (AndroidAutoDetector.METHOD_MEDIA_SESSION_PLAY_FROM_SEARCH.equals(method.getName()) && this.mContext.getEvaluator().parametersMatch(method, "java.lang.String", AndroidAutoDetector.BUNDLE_ARG)) {
                this.mOnPlayFromSearchFound = true;
            }
        }
    }
}

