/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteral;
import java.util.Collections;
import java.util.List;

public class AssertDetector
extends Detector
implements Detector.JavaPsiScanner {
    public static final Issue ISSUE = Issue.create("Assert", "Assertions", "Assertions are not checked at runtime. There are ways to request that they be used by Dalvik (`adb shell setprop debug.assert 1`), but the property is ignored in many places and can not be relied upon. Instead, perform conditional checking inside `if (BuildConfig.DEBUG) { }` blocks. That constant is a static final boolean which is true in debug builds and false in release builds, and the Java compiler completely removes all code inside the if-body from the app.\n\nFor example, you can replace `assert speed > 0` with `if (BuildConfig.DEBUG && !(speed > 0)) { throw new AssertionError() }`.\n\n(Note: This lint check does not flag assertions purely asserting nullness or non-nullness; these are typically more intended for tools usage than runtime checks.)", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(AssertDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("https://code.google.com/p/android/issues/detail?id=65183");

    @Override
    public List<Class<? extends PsiElement>> getApplicablePsiTypes() {
        return Collections.singletonList(PsiAssertStatement.class);
    }

    @Override
    public JavaElementVisitor createPsiVisitor(final JavaContext context) {
        if (!context.getMainProject().isAndroidProject()) {
            return null;
        }
        return new JavaElementVisitor(){

            public void visitAssertStatement(PsiAssertStatement node) {
                Object value;
                PsiExpression assertion = node.getAssertCondition();
                if (assertion instanceof PsiLiteral ? Boolean.TRUE.equals(value = ((PsiLiteral)assertion).getValue()) : AssertDetector.isNullCheck(assertion)) {
                    return;
                }
                String message = "Assertions are unreliable. Use `BuildConfig.DEBUG` conditional checks instead.";
                context.report(ISSUE, (PsiElement)node, context.getLocation((PsiElement)node), message);
            }
        };
    }

    private static boolean isNullCheck(PsiExpression expression) {
        if (expression instanceof PsiBinaryExpression) {
            PsiBinaryExpression binExp = (PsiBinaryExpression)expression;
            PsiExpression lOperand = binExp.getLOperand();
            PsiExpression rOperand = binExp.getROperand();
            if (LintUtils.isNullLiteral((PsiElement)lOperand) || LintUtils.isNullLiteral((PsiElement)rOperand)) {
                return true;
            }
            return AssertDetector.isNullCheck(lOperand) && AssertDetector.isNullCheck(rOperand);
        }
        return false;
    }
}

