/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import java.util.Collections;
import java.util.List;

public class SdCardDetector
extends Detector
implements Detector.JavaPsiScanner {
    public static final Issue ISSUE = Issue.create("SdCardPath", "Hardcoded reference to `/sdcard`", "Your code should not reference the `/sdcard` path directly; instead use `Environment.getExternalStorageDirectory().getPath()`.\n\nSimilarly, do not reference the `/data/data/` path directly; it can vary in multi-user scenarios. Instead, use `Context.getFilesDir().getPath()`.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(SdCardDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/guide/topics/data/data-storage.html#filesExternal");

    @Override
    public List<Class<? extends PsiElement>> getApplicablePsiTypes() {
        return Collections.singletonList(PsiLiteralExpression.class);
    }

    @Override
    public JavaElementVisitor createPsiVisitor(JavaContext context) {
        return new StringChecker(context);
    }

    private static class StringChecker
    extends JavaElementVisitor {
        private final JavaContext mContext;

        public StringChecker(JavaContext context) {
            this.mContext = context;
        }

        public void visitLiteralExpression(PsiLiteralExpression node) {
            PsiType type = node.getType();
            if (type != null && type.getCanonicalText().equals("java.lang.String")) {
                String s = (String)node.getValue();
                if (s == null || s.isEmpty()) {
                    return;
                }
                char c = s.charAt(0);
                if (c != '/' && c != 'f') {
                    return;
                }
                if (s.startsWith("/sdcard") || s.startsWith("/mnt/sdcard/") || s.startsWith("/system/media/sdcard") || s.startsWith("file://sdcard/") || s.startsWith("file:///sdcard/")) {
                    String message = "Do not hardcode \"/sdcard/\"; use `Environment.getExternalStorageDirectory().getPath()` instead";
                    Location location = this.mContext.getLocation((PsiElement)node);
                    this.mContext.report(ISSUE, (PsiElement)node, location, message);
                } else if (s.startsWith("/data/data/") || s.startsWith("/data/user/")) {
                    String message = "Do not hardcode \"`/data/`\"; use `Context.getFilesDir().getPath()` instead";
                    Location location = this.mContext.getLocation((PsiElement)node);
                    this.mContext.report(ISSUE, (PsiElement)node, location, message);
                }
            }
        }
    }
}

