/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.multiplex;

import com.android.tools.rpclib.multiplex.PipeInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public class Channel
implements Closeable {
    private final OutputStream mOutputStream;
    private final InputStream mInputStream;
    private final PipeInputStream mPipeInputStream;
    private final long mId;
    private final EventHandler mEventHandler;
    private boolean mIsClosed;

    /*
     * WARNING - void declaration
     */
    public Channel(long id, @NotNull EventHandler eventHandler) {
        void events;
        if (eventHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/android/tools/rpclib/multiplex/Channel", "<init>"));
        }
        PipeInputStream in = new PipeInputStream();
        this.mId = id;
        this.mEventHandler = events;
        this.mInputStream = in;
        this.mOutputStream = new Output();
        this.mPipeInputStream = in;
    }

    public InputStream getInputStream() {
        return this.mInputStream;
    }

    public OutputStream getOutputStream() {
        return this.mOutputStream;
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.mIsClosed) {
            this.mIsClosed = true;
            this.mEventHandler.closeChannel(this.mId);
            this.mInputStream.close();
            this.mOutputStream.close();
        }
    }

    void receive(byte[] data) throws IOException {
        this.mPipeInputStream.getSource().write(data);
    }

    synchronized void closeNoEvent() throws IOException {
        if (!this.mIsClosed) {
            this.mIsClosed = true;
            this.mInputStream.close();
            this.mOutputStream.close();
        }
    }

    private class Output
    extends OutputStream {
        private Output() {
        }

        @Override
        public void write(int b) throws IOException, UnsupportedOperationException {
            this.write(new byte[]{(byte)b}, 0, 1);
            throw new UnsupportedOperationException("Use write(byte[], int, int) instead of writing single bytes!");
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Channel.this.mEventHandler.writeChannel(Channel.this.mId, b, off, len);
        }

        @Override
        public void close() throws IOException {
            Channel.this.close();
        }
    }

    static interface EventHandler {
        public void closeChannel(long var1) throws IOException;

        public void writeChannel(long var1, byte[] var3, int var4, int var5) throws IOException;
    }
}

