/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.build;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.psi.PsiClass;
import com.intellij.task.ExecuteRunConfigurationTask;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.build.GradleExecutionEnvironmentProvider;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleApplicationEnvironmentProvider
implements GradleExecutionEnvironmentProvider {
    @Override
    public boolean isApplicable(ExecuteRunConfigurationTask task) {
        return task.getRunProfile() instanceof ApplicationConfiguration;
    }

    @Override
    @Nullable
    public ExecutionEnvironment createExecutionEnvironment(@NotNull Project project, @NotNull ExecuteRunConfigurationTask executeRunConfigurationTask, @Nullable Executor executor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/execution/build/GradleApplicationEnvironmentProvider", "createExecutionEnvironment"));
        }
        if (executeRunConfigurationTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executeRunConfigurationTask", "org/jetbrains/plugins/gradle/execution/build/GradleApplicationEnvironmentProvider", "createExecutionEnvironment"));
        }
        if (!this.isApplicable(executeRunConfigurationTask)) {
            return null;
        }
        ApplicationConfiguration applicationConfiguration = (ApplicationConfiguration)executeRunConfigurationTask.getRunProfile();
        PsiClass mainClass = applicationConfiguration.getMainClass();
        if (mainClass == null) {
            return null;
        }
        Module module = ProjectFileIndex.SERVICE.getInstance((Project)project).getModuleForFile(mainClass.getContainingFile().getVirtualFile());
        if (module == null) {
            return null;
        }
        JavaParameters params = new JavaParameters();
        JavaParametersUtil.configureConfiguration((SimpleJavaParameters)params, (CommonJavaRunConfigurationParameters)applicationConfiguration);
        params.getVMParametersList().addParametersString(applicationConfiguration.getVMParameters());
        StringBuilder parametersString = new StringBuilder();
        for (Object parameter : params.getProgramParametersList().getParameters()) {
            parametersString.append("args '").append((String)parameter).append("'\n");
        }
        StringBuilder vmParametersString = new StringBuilder();
        for (String parameter : params.getVMParametersList().getParameters()) {
            vmParametersString.append("jvmArgs '").append(parameter).append("'\n");
        }
        ExternalSystemTaskExecutionSettings taskSettings = new ExternalSystemTaskExecutionSettings();
        taskSettings.setExternalSystemIdString(GradleConstants.SYSTEM_ID.getId());
        taskSettings.setExternalProjectPath(ExternalSystemApiUtil.getExternalProjectPath((Module)module));
        String runAppTaskName = "run " + mainClass.getName();
        taskSettings.setTaskNames(Collections.singletonList(runAppTaskName));
        String executorId = executor == null ? DefaultRunExecutor.EXECUTOR_ID : executor.getId();
        ExecutionEnvironment environment = ExternalSystemUtil.createExecutionEnvironment((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (ExternalSystemTaskExecutionSettings)taskSettings, (String)executorId);
        if (environment != null) {
            int lastPathDelimiterIndex;
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = environment.getRunnerAndConfigurationSettings();
            assert (runnerAndConfigurationSettings != null);
            ExternalSystemRunConfiguration runConfiguration = (ExternalSystemRunConfiguration)runnerAndConfigurationSettings.getConfiguration();
            String gradlePath = ExternalSystemApiUtil.getExternalProjectId((Module)module);
            int n = lastPathDelimiterIndex = gradlePath == null ? -1 : gradlePath.lastIndexOf(58);
            if (gradlePath == null || !gradlePath.startsWith(":")) {
                gradlePath = ":";
            } else if (!gradlePath.equals(":")) {
                gradlePath = gradlePath.substring(0, lastPathDelimiterIndex);
            }
            String sourceSetName = GradleProjectResolverUtil.getSourceSetName(module);
            String initScript = "projectsEvaluated {\n  rootProject.allprojects {\n    if(project.path == '" + gradlePath + "' && project.sourceSets) {\n      project.tasks.create(name: '" + runAppTaskName + "', overwrite: true, type: JavaExec) {\n        classpath = project.sourceSets.'" + sourceSetName + "'.runtimeClasspath\n        main = '" + mainClass.getQualifiedName() + "'\n" + parametersString.toString() + vmParametersString.toString() + "      }\n    }\n  }\n}\n";
            runConfiguration.putUserData(GradleTaskManager.INIT_SCRIPT_KEY, (Object)initScript);
            return environment;
        }
        return null;
    }
}

