/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.resolve.GradleExtensionsContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleResolverUtil;
import org.jetbrains.plugins.gradle.settings.GradleExtensionsSettings;
import org.jetbrains.plugins.groovy.extensions.GroovyUnresolvedHighlightFilter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GradleUnresolvedReferenceFilter
extends GroovyUnresolvedHighlightFilter {
    private static final Set<String> IGNORE_SET = ContainerUtil.newHashSet((Object[])new String[]{"org.gradle.api.Task", "org.gradle.api.tasks.SourceSet", "org.gradle.api.artifacts.Configuration", "org.gradle.api.distribution.Distribution"});

    public boolean isReject(@NotNull GrReferenceExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/gradle/service/resolve/GradleUnresolvedReferenceFilter", "isReject"));
        }
        PsiType psiType = GradleResolverUtil.getTypeOf((GrExpression)expression);
        if (psiType == null) {
            PsiType type;
            PsiElement child = expression.getFirstChild();
            if (child == null) {
                return false;
            }
            PsiReference reference = child.getReference();
            if (reference instanceof GrReferenceExpression && (type = ((GrReferenceExpression)reference).getType()) != null) {
                PsiClassType extType = TypesUtil.createGenericType((String)"org.gradle.api.plugins.ExtraPropertiesExtension", (PsiElement)expression, null);
                ConversionResult result = TypesUtil.canCast((PsiType)extType, (PsiType)type, (PsiElement)expression);
                return result == ConversionResult.OK;
            }
            return false;
        }
        HashSet<String> toIgnore = new HashSet<String>(IGNORE_SET);
        GradleExtensionsSettings.GradleExtensionsData extensionsData = GradleExtensionsContributor.Companion.getExtensionsFor((PsiElement)expression);
        if (extensionsData != null) {
            for (GradleExtensionsSettings.GradleExtension extension : extensionsData.extensions) {
                if (!StringUtil.isNotEmpty((String)extension.namedObjectTypeFqn)) continue;
                toIgnore.add(extension.namedObjectTypeFqn);
            }
        }
        return toIgnore.contains(TypesUtil.getQualifiedName((PsiType)psiType));
    }
}

