/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleExtensionsContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleResolverUtil;
import org.jetbrains.plugins.gradle.settings.GradleExtensionsSettings;
import org.jetbrains.plugins.groovy.extensions.GroovyMapContentProvider;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrReferenceTypeEnhancer;

public class NamedDomainObjectCollectionTypeEnhancer
extends GrReferenceTypeEnhancer {
    public PsiType getReferenceType(GrReferenceExpression ref, @Nullable PsiElement resolved) {
        PsiElement qResolved;
        if (resolved != null) {
            return null;
        }
        GrExpression qualifierExpression = ref.getQualifierExpression();
        if (qualifierExpression == null) {
            return null;
        }
        PsiType namedDomainCollectionType = GradleResolverUtil.getTypeOf(qualifierExpression);
        if (!GroovyPsiManager.isInheritorCached((PsiType)namedDomainCollectionType, (String)"org.gradle.api.NamedDomainObjectCollection")) {
            return null;
        }
        if (qualifierExpression instanceof GrReferenceExpression) {
            qResolved = ((GrReferenceExpression)qualifierExpression).resolve();
        } else if (qualifierExpression instanceof GrMethodCall) {
            qResolved = ((GrMethodCall)qualifierExpression).resolveMethod();
        } else {
            return null;
        }
        String key = ref.getReferenceName();
        if (key == null) {
            return null;
        }
        for (GroovyMapContentProvider provider : (GroovyMapContentProvider[])GroovyMapContentProvider.EP_NAME.getExtensions()) {
            PsiType type = provider.getValueType(qualifierExpression, qResolved, key);
            if (type == null) continue;
            return type;
        }
        if (namedDomainCollectionType instanceof PsiClassReferenceType) {
            PsiClassReferenceType referenceType = (PsiClassReferenceType)namedDomainCollectionType;
            String fqName = TypesUtil.getQualifiedName((PsiType)referenceType);
            if ("org.gradle.api.tasks.SourceSetContainer".equals(fqName)) {
                GroovyPsiManager psiManager = GroovyPsiManager.getInstance((Project)ref.getProject());
                return psiManager.createTypeByFQClassName("org.gradle.api.tasks.SourceSet", ref.getResolveScope());
            }
            if ("org.gradle.api.artifacts.ConfigurationContainer".equals(fqName)) {
                GroovyPsiManager psiManager = GroovyPsiManager.getInstance((Project)ref.getProject());
                return psiManager.createTypeByFQClassName("org.gradle.api.artifacts.Configuration", ref.getResolveScope());
            }
            if ("org.gradle.api.tasks.TaskContainer".equals(fqName)) {
                GroovyPsiManager psiManager = GroovyPsiManager.getInstance((Project)ref.getProject());
                return psiManager.createTypeByFQClassName("org.gradle.api.Task", ref.getResolveScope());
            }
            if ("org.gradle.api.distribution.DistributionContainer".equals(fqName)) {
                GroovyPsiManager psiManager = GroovyPsiManager.getInstance((Project)ref.getProject());
                return psiManager.createTypeByFQClassName("org.gradle.api.distribution.Distribution", ref.getResolveScope());
            }
            GradleExtensionsSettings.GradleExtensionsData extensionsData = GradleExtensionsContributor.Companion.getExtensionsFor((PsiElement)ref);
            if (extensionsData != null) {
                for (GradleExtensionsSettings.GradleExtension extension : extensionsData.extensions) {
                    if (!StringUtil.isNotEmpty((String)extension.namedObjectTypeFqn) || !extension.rootTypeFqn.equals(fqName)) continue;
                    GroovyPsiManager psiManager = GroovyPsiManager.getInstance((Project)ref.getProject());
                    return psiManager.createTypeByFQClassName(extension.namedObjectTypeFqn, ref.getResolveScope());
                }
            }
        }
        return null;
    }
}

