/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Text;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.config.GradleSettingsListenerAdapter;
import org.jetbrains.plugins.gradle.model.ExternalTask;
import org.jetbrains.plugins.gradle.model.GradleExtensions;
import org.jetbrains.plugins.gradle.model.GradleProperty;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@State(name="GradleExtensions", storages={@Storage(value="gradle_extensions.xml")})
public class GradleExtensionsSettings
implements PersistentStateComponent<Settings> {
    private static final Logger LOG = Logger.getInstance(GradleExtensionsSettings.class);
    private final Settings myState = new Settings();

    public GradleExtensionsSettings(Project project) {
        ExternalSystemApiUtil.subscribe((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (ExternalSystemSettingsListener)new GradleSettingsListenerAdapter(){

            public void onProjectsUnlinked(@NotNull Set<String> linkedProjectPaths) {
                if (linkedProjectPaths == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkedProjectPaths", "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$1", "onProjectsUnlinked"));
                }
                GradleExtensionsSettings.this.myState.remove(linkedProjectPaths);
            }
        });
    }

    @Nullable
    public Settings getState() {
        return this.myState;
    }

    public void loadState(Settings state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myState);
        for (GradleProject gradleProject : this.myState.projects.values()) {
            for (GradleExtensionsData extensionsData : gradleProject.extensions.values()) {
                extensionsData.myGradleProject = gradleProject;
            }
        }
    }

    @NotNull
    public static Settings getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings", "getInstance"));
        }
        Settings settings = ((GradleExtensionsSettings)ServiceManager.getService((Project)project, GradleExtensionsSettings.class)).myState;
        if (settings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings", "getInstance"));
        }
        return settings;
    }

    @Tag(value="conf")
    public static class GradleConfiguration {
        @Attribute(value="name")
        public String name;
        @Attribute(value="visible")
        public boolean visible = true;
        @Attribute(value="scriptClasspath")
        public boolean scriptClasspath;
        @Text
        public String description;
    }

    @Tag(value="task")
    public static class GradleTask
    implements TypeAware {
        @Attribute(value="name")
        public String name;
        @Attribute(value="type")
        public String typeFqn = "org.gradle.api.DefaultTask";
        @Text
        @Nullable
        public String description;

        @Override
        public String getTypeFqn() {
            return this.typeFqn;
        }
    }

    @Tag(value="prop")
    public static class GradleProp
    implements TypeAware {
        @Attribute(value="name")
        public String name;
        @Attribute(value="type")
        public String typeFqn = "java.lang.String";
        @Text
        @Nullable
        public String value;

        @Override
        public String getTypeFqn() {
            return this.typeFqn;
        }
    }

    @Tag(value="ext")
    public static class GradleExtension
    implements TypeAware {
        @Attribute(value="name")
        public String name;
        @Attribute(value="type")
        public String rootTypeFqn = "Object";
        @Attribute(value="objectType")
        public String namedObjectTypeFqn;

        @Override
        public String getTypeFqn() {
            return this.rootTypeFqn;
        }
    }

    public static interface TypeAware {
        public String getTypeFqn();
    }

    @Tag(value="extensions")
    public static class GradleExtensionsData {
        @Transient
        private GradleProject myGradleProject;
        @Attribute(value="parent")
        public String parent;
        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false)
        public List<GradleExtension> extensions = new SmartList();
        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false)
        public List<GradleProp> properties = new SmartList();
        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false)
        public List<GradleTask> tasks = new SmartList();
        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false)
        public List<GradleConfiguration> configurations = new SmartList();

        @Transient
        @Nullable
        public GradleExtensionsData getParent() {
            if (this.myGradleProject == null) {
                return null;
            }
            return this.myGradleProject.extensions.get(this.parent);
        }

        @Nullable
        public GradleProp findProperty(@Nullable String name) {
            return GradleExtensionsData.findProperty(this, name);
        }

        @NotNull
        public Collection<GradleProp> findAllProperties() {
            Collection<GradleProp> collection = GradleExtensionsData.findAllProperties(this, ContainerUtil.newHashMap());
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleExtensionsData", "findAllProperties"));
            }
            return collection;
        }

        @NotNull
        private static Collection<GradleProp> findAllProperties(@NotNull GradleExtensionsData extensionsData, @NotNull Map<String, GradleProp> result) {
            if (extensionsData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionsData", "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleExtensionsData", "findAllProperties"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleExtensionsData", "findAllProperties"));
            }
            for (GradleProp property : extensionsData.properties) {
                if (result.containsKey(property.name)) continue;
                result.put(property.name, property);
            }
            if (extensionsData.getParent() != null) {
                GradleExtensionsData.findAllProperties(extensionsData.getParent(), result);
            }
            Collection<GradleProp> collection = result.values();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleExtensionsData", "findAllProperties"));
            }
            return collection;
        }

        @Nullable
        private static GradleProp findProperty(@NotNull GradleExtensionsData extensionsData, String propName) {
            GradleExtensionsData parentData;
            if (extensionsData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionsData", "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleExtensionsData", "findProperty"));
            }
            for (GradleProp property : extensionsData.properties) {
                if (!property.name.equals(propName)) continue;
                return property;
            }
            if (extensionsData.parent != null && extensionsData.myGradleProject != null && (parentData = extensionsData.myGradleProject.extensions.get(extensionsData.parent)) != null) {
                return GradleExtensionsData.findProperty(parentData, propName);
            }
            return null;
        }
    }

    @Tag(value="sub-project")
    static class GradleProject {
        @Property(surroundWithTag=false)
        @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false, entryTagName="project", keyAttributeName="path")
        @NotNull
        public Map<String, GradleExtensionsData> extensions = new HashMap<String, GradleExtensionsData>();

        GradleProject() {
        }
    }

    public static class Settings {
        @Property(surroundWithTag=false)
        @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false, entryTagName="project", keyAttributeName="path")
        @NotNull
        public Map<String, GradleProject> projects = new HashMap<String, GradleProject>();

        public void add(@NotNull String rootPath, @NotNull Map<String, GradleExtensions> extensions) {
            if (rootPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$Settings", "add"));
            }
            if (extensions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$Settings", "add"));
            }
            GradleProject gradleProject = new GradleProject();
            for (Map.Entry<String, GradleExtensions> entry : extensions.entrySet()) {
                GradleExtensionsData extensionsData = new GradleExtensionsData();
                GradleExtensions gradleExtensions = entry.getValue();
                try {
                    File parentProjectDir = gradleExtensions.getParentProjectDir();
                    if (parentProjectDir != null) {
                        extensionsData.parent = ExternalSystemApiUtil.toCanonicalPath((String)parentProjectDir.getCanonicalPath());
                    }
                }
                catch (IOException e) {
                    LOG.warn("construction of the canonical path for the gradle project fails", (Throwable)e);
                }
                for (org.jetbrains.plugins.gradle.model.GradleExtension extension : gradleExtensions.getExtensions()) {
                    GradleExtension gradleExtension = new GradleExtension();
                    gradleExtension.name = extension.getName();
                    gradleExtension.rootTypeFqn = extension.getTypeFqn();
                    gradleExtension.namedObjectTypeFqn = extension.getNamedObjectTypeFqn();
                    extensionsData.extensions.add(gradleExtension);
                }
                for (GradleProperty property : gradleExtensions.getGradleProperties()) {
                    GradleProp gradleProp = new GradleProp();
                    gradleProp.name = property.getName();
                    gradleProp.typeFqn = property.getTypeFqn();
                    Serializable value = property.getValue();
                    if (value != null) {
                        gradleProp.value = value.toString();
                    }
                    extensionsData.properties.add(gradleProp);
                }
                for (ExternalTask task : gradleExtensions.getTasks()) {
                    GradleTask gradleTask = new GradleTask();
                    gradleTask.name = task.getName();
                    String type = task.getType();
                    if (type != null) {
                        gradleTask.typeFqn = type;
                    }
                    StringBuilder description = new StringBuilder();
                    if (task.getDescription() != null) {
                        description.append(task.getDescription());
                        if (task.getGroup() != null) {
                            description.append("<p>");
                        }
                    }
                    if (task.getGroup() != null) {
                        description.append("<i>Task group: ").append(task.getGroup()).append("<i>");
                    }
                    gradleTask.description = description.toString();
                    extensionsData.tasks.add(gradleTask);
                }
                for (org.jetbrains.plugins.gradle.model.GradleConfiguration configuration : gradleExtensions.getConfigurations()) {
                    GradleConfiguration gradleConfiguration = new GradleConfiguration();
                    gradleConfiguration.name = configuration.getName();
                    gradleConfiguration.description = configuration.getDescription();
                    gradleConfiguration.visible = configuration.isVisible();
                    gradleConfiguration.scriptClasspath = configuration.isScriptClasspathConfiguration();
                    extensionsData.configurations.add(gradleConfiguration);
                }
                gradleProject.extensions.put(entry.getKey(), extensionsData);
                extensionsData.myGradleProject = gradleProject;
            }
            HashMap<String, GradleProject> projects = new HashMap<String, GradleProject>(this.projects);
            projects.put(rootPath, gradleProject);
            this.projects = projects;
        }

        public void remove(Set<String> rootPaths) {
            HashMap<String, GradleProject> projects = new HashMap<String, GradleProject>(this.projects);
            for (String path : rootPaths) {
                projects.remove(path);
            }
            this.projects = projects;
        }

        @Nullable
        public GradleExtensionsData getExtensionsFor(@Nullable Module module) {
            if (module == null) {
                return null;
            }
            return this.getExtensionsFor(ExternalSystemApiUtil.getExternalRootProjectPath((Module)module), ExternalSystemApiUtil.getExternalProjectPath((Module)module));
        }

        @Nullable
        public GradleExtensionsData getExtensionsFor(@Nullable String rootProjectPath, @Nullable String projectPath) {
            if (rootProjectPath == null || projectPath == null) {
                return null;
            }
            GradleProject gradleProject = this.projects.get(rootProjectPath);
            if (gradleProject == null) {
                return null;
            }
            return gradleProject.extensions.get(projectPath);
        }
    }
}

