/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class ToggleHighlightingMarkupAction
extends AnAction {
    public void update(AnActionEvent e) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        e.getPresentation().setEnabled(editor != null && file != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(AnActionEvent e) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        if (editor == null || file == null) {
            return;
        }
        Project project = file.getProject();
        CommandProcessorEx commandProcessor = (CommandProcessorEx)CommandProcessor.getInstance();
        Object commandToken = commandProcessor.startCommand(project, e.getPresentation().getText(), (Object)e.getPresentation().getText(), UndoConfirmationPolicy.DEFAULT);
        try {
            WriteAction.run(() -> {
                SelectionModel selectionModel = editor.getSelectionModel();
                int[] starts = selectionModel.getBlockSelectionStarts();
                int[] ends = selectionModel.getBlockSelectionEnds();
                int startOffset = starts.length == 0 ? 0 : starts[0];
                int endOffset = ends.length == 0 ? editor.getDocument().getTextLength() : ends[ends.length - 1];
                ToggleHighlightingMarkupAction.perform(project, editor.getDocument(), startOffset, endOffset);
            });
        }
        finally {
            commandProcessor.finishCommand(project, commandToken, null);
        }
    }

    private static void perform(Project project, Document document, int startOffset, int endOffset) {
        CharSequence sequence = document.getCharsSequence();
        StringBuilder sb = new StringBuilder();
        Pattern pattern = Pattern.compile("<(error|warning|EOLError|EOLWarning|info|weak_warning)((?:\\s|=|\\w+|\\\"(?:[^\"]|\\\\\\\")*?\\\")*?)>(.*?)</\\1>");
        Matcher matcher = pattern.matcher(sequence);
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        if (matcher.find(startOffset)) {
            boolean compactMode = false;
            while (matcher.start(0) < endOffset) {
                int pos;
                if (matcher.start(2) < matcher.end(2)) {
                    if (!compactMode) {
                        ranges.clear();
                        compactMode = true;
                    }
                    ranges.add(new TextRange(matcher.start(2), matcher.end(2)));
                } else if (!compactMode) {
                    ranges.add(new TextRange(matcher.start(0), matcher.start(3)));
                    ranges.add(new TextRange(matcher.end(3), matcher.end(0)));
                }
                if (matcher.find(pos = Math.max(matcher.end(1), matcher.end(2)))) continue;
            }
            Collections.sort(ranges, Segment.BY_START_OFFSET_THEN_END_OFFSET);
        }
        if (!ranges.isEmpty()) {
            int pos = 0;
            for (TextRange range : ranges) {
                sb.append(sequence, pos, range.getStartOffset());
                pos = range.getEndOffset();
            }
            sb.append(sequence, pos, sequence.length());
        } else {
            int[] offset = new int[]{0};
            ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
            DaemonCodeAnalyzerEx.processHighlights((Document)document, (Project)project, (HighlightSeverity)HighlightSeverity.WARNING, (int)0, (int)sequence.length(), info -> {
                if (info.getSeverity() != HighlightSeverity.WARNING && info.getSeverity() != HighlightSeverity.ERROR) {
                    return true;
                }
                if (info.getStartOffset() >= endOffset) {
                    return false;
                }
                if (info.getEndOffset() > startOffset) {
                    offset[0] = ToggleHighlightingMarkupAction.appendInfo(info, sb, sequence, offset[0], infos);
                }
                return true;
            });
            offset[0] = ToggleHighlightingMarkupAction.appendInfo(null, sb, sequence, offset[0], infos);
            sb.append(sequence.subSequence(offset[0], sequence.length()));
        }
        document.setText((CharSequence)sb);
    }

    private static int appendInfo(@Nullable HighlightInfo info, StringBuilder sb, CharSequence sequence, int offset, ArrayList<HighlightInfo> infos) {
        if (info == null || !infos.isEmpty() && ToggleHighlightingMarkupAction.getMaxEnd(infos) < info.getStartOffset()) {
            if (infos.size() == 1) {
                HighlightInfo cur = infos.remove(0);
                sb.append(sequence.subSequence(offset, cur.getStartOffset()));
                ToggleHighlightingMarkupAction.appendTag(sb, cur, true);
                sb.append(sequence.subSequence(cur.getStartOffset(), cur.getEndOffset()));
                ToggleHighlightingMarkupAction.appendTag(sb, cur, false);
                offset = cur.getEndOffset();
            } else {
                LinkedList<HighlightInfo> stack = new LinkedList<HighlightInfo>();
                for (HighlightInfo cur : infos) {
                    offset = ToggleHighlightingMarkupAction.processStack(stack, sb, sequence, offset, cur.getStartOffset());
                    sb.append(sequence.subSequence(offset, cur.getStartOffset()));
                    offset = cur.getStartOffset();
                    ToggleHighlightingMarkupAction.appendTag(sb, cur, true);
                    stack.addLast(cur);
                }
                offset = ToggleHighlightingMarkupAction.processStack(stack, sb, sequence, offset, sequence.length());
                infos.clear();
            }
        }
        if (info != null) {
            boolean found = false;
            for (HighlightInfo cur : infos) {
                if (cur.getStartOffset() != info.getStartOffset() || cur.getEndOffset() != info.getEndOffset() || cur.getSeverity() != info.getSeverity()) continue;
                found = true;
                break;
            }
            if (!found) {
                infos.add(info);
            }
        }
        return offset;
    }

    private static int getMaxEnd(ArrayList<HighlightInfo> infos) {
        int max = -1;
        for (HighlightInfo info : infos) {
            int endOffset = info.getEndOffset();
            if (max >= endOffset) continue;
            max = endOffset;
        }
        return max;
    }

    private static int processStack(LinkedList<HighlightInfo> stack, StringBuilder sb, CharSequence sequence, int offset, int endOffset) {
        if (stack.isEmpty()) {
            return offset;
        }
        HighlightInfo cur = stack.peekLast();
        while (cur != null && cur.getEndOffset() <= endOffset) {
            stack.removeLast();
            if (offset <= cur.getEndOffset()) {
                sb.append(sequence.subSequence(offset, cur.getEndOffset()));
            }
            offset = cur.getEndOffset();
            ToggleHighlightingMarkupAction.appendTag(sb, cur, false);
            cur = stack.peekLast();
        }
        return offset;
    }

    private static void appendTag(StringBuilder sb, HighlightInfo cur, boolean opening) {
        sb.append("<");
        if (!opening) {
            sb.append("/");
        }
        if (cur.isAfterEndOfLine()) {
            sb.append(cur.getSeverity() == HighlightSeverity.WARNING ? "EOLWarning" : "EOLError");
        } else {
            sb.append(cur.getSeverity() == HighlightSeverity.WARNING ? "warning" : "error");
        }
        if (opening) {
            sb.append(" descr=\"").append(cur.getDescription()).append("\"");
        }
        sb.append(">");
    }
}

