/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.PsiUtil;

public abstract class DevKitInspectionBase
extends BaseJavaLocalInspectionTool {
    @NotNull
    public final PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/idea/devkit/inspections/DevKitInspectionBase", "buildVisitor"));
        }
        PsiElementVisitor psiElementVisitor = this.isAllowed(holder) ? this.buildInternalVisitor(holder, isOnTheFly) : PsiElementVisitor.EMPTY_VISITOR;
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/DevKitInspectionBase", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    protected boolean isAllowed(ProblemsHolder holder) {
        if (PsiUtil.isIdeaProject(holder.getProject())) {
            return true;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)holder.getFile());
        if (PluginModuleType.isPluginModuleOrDependency(module)) {
            return true;
        }
        return ApplicationManager.getApplication().isUnitTestMode();
    }

    protected PsiElementVisitor buildInternalVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/idea/devkit/inspections/DevKitInspectionBase", "buildInternalVisitor"));
        }
        return super.buildVisitor(holder, isOnTheFly);
    }
}

