/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.Query;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import java.util.HashSet;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.inspections.DescriptionCheckerUtil;
import org.jetbrains.idea.devkit.inspections.DescriptionType;
import org.jetbrains.idea.devkit.inspections.quickfix.PluginDescriptorChooser;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class InspectionDescriptionInfo {
    private static final Logger LOG = Logger.getInstance(InspectionDescriptionInfo.class);
    private final String myFilename;
    private final PsiMethod myMethod;
    private final PsiFile myDescriptionFile;

    private InspectionDescriptionInfo(String filename, @Nullable PsiMethod method, @Nullable PsiFile descriptionFile) {
        this.myFilename = filename;
        this.myMethod = method;
        this.myDescriptionFile = descriptionFile;
    }

    public static InspectionDescriptionInfo create(Module module, PsiClass psiClass) {
        String className;
        PsiMethod method = PsiUtil.findNearestMethod("getShortName", psiClass);
        if (method != null && method.getContainingClass().hasModifierProperty("abstract")) {
            method = null;
        }
        String filename = null;
        if (method == null) {
            Extension extension;
            className = psiClass.getQualifiedName();
            if (className != null && (extension = InspectionDescriptionInfo.findExtension(module, psiClass)) != null) {
                filename = extension.getXmlTag().getAttributeValue("shortName");
            }
        } else {
            filename = PsiUtil.getReturnedLiteral(method, psiClass);
        }
        if (filename == null) {
            className = psiClass.getName();
            LOG.assertTrue(className != null, (Object)psiClass);
            filename = InspectionProfileEntry.getShortName((String)className);
        }
        PsiFile descriptionFile = InspectionDescriptionInfo.resolveInspectionDescriptionFile(module, filename);
        return new InspectionDescriptionInfo(filename, method, descriptionFile);
    }

    @Nullable
    static Extension findExtension(Module module, PsiClass psiClass) {
        return (Extension)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            Extension extension = InspectionDescriptionInfo.doFindExtension(module, psiClass);
            return CachedValueProvider.Result.create((Object)extension, (Object[])new Object[]{extension == null ? PsiModificationTracker.MODIFICATION_COUNT : extension.getXmlTag()});
        });
    }

    @Nullable
    private static Extension doFindExtension(Module module, PsiClass psiClass) {
        Project project = module.getProject();
        HashSet processed = new HashSet();
        for (GlobalSearchScope scope : DescriptionCheckerUtil.searchScopes(module)) {
            List origElements = DomService.getInstance().getFileElements(IdeaPlugin.class, project, scope);
            origElements.removeAll(processed);
            List<DomFileElement<IdeaPlugin>> elements = PluginDescriptorChooser.findAppropriateIntelliJModule(module.getName(), origElements);
            Query query = ReferencesSearch.search((PsiElement)psiClass, (SearchScope)new LocalSearchScope((PsiElement[])elements.stream().map(DomFileElement::getFile).toArray(PsiElement[]::new)));
            Ref result = Ref.create(null);
            query.forEach(ref -> {
                Extension extension;
                ExtensionPoint extensionPoint;
                DomElement domElement;
                PsiElement parent;
                PsiElement element = ref.getElement();
                if (element instanceof XmlAttributeValue && (parent = element.getParent()) instanceof XmlAttribute && "implementationClass".equals(((XmlAttribute)parent).getName()) && (domElement = DomUtil.getDomElement((PsiElement)parent.getParent())) instanceof Extension && (extensionPoint = (extension = (Extension)domElement).getExtensionPoint()) != null && InheritanceUtil.isInheritor((PsiClass)((PsiClass)extensionPoint.getBeanClass().getValue()), (String)InspectionEP.class.getName())) {
                    result.set((Object)extension);
                    return false;
                }
                return true;
            });
            Extension extension = (Extension)result.get();
            if (extension != null) {
                return extension;
            }
            processed.addAll(origElements);
        }
        return null;
    }

    @Nullable
    private static PsiFile resolveInspectionDescriptionFile(Module module, @Nullable String filename) {
        if (filename == null) {
            return null;
        }
        String nameWithSuffix = filename + ".html";
        return ((StreamEx)DescriptionCheckerUtil.allDescriptionDirs(module, DescriptionType.INSPECTION).map(description -> description.findFile(nameWithSuffix)).nonNull()).findFirst().orElse(null);
    }

    public boolean isValid() {
        return this.myFilename != null;
    }

    public String getFilename() {
        assert (this.isValid());
        return this.myFilename;
    }

    @Nullable
    public PsiMethod getShortNameMethod() {
        return this.myMethod;
    }

    @Nullable
    public PsiFile getDescriptionFile() {
        return this.myDescriptionFile;
    }

    public boolean hasDescriptionFile() {
        return this.getDescriptionFile() != null;
    }
}

