/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.emulator;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.j2meplugin.run.J2MERunConfiguration;
import com.intellij.j2meplugin.run.J2MERunnableState;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class EmulatorType
implements PluginAware {
    public static final ExtensionPointName<EmulatorType> EMULATOR_TYPE_EXTENSION = ExtensionPointName.create((String)"J2ME.com.intellij.emulatorType");
    private PluginDescriptor myPluginDescriptor;

    public void setPluginDescriptor(PluginDescriptor pluginDescriptor) {
        this.myPluginDescriptor = pluginDescriptor;
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.myPluginDescriptor;
    }

    @NonNls
    public abstract String getName();

    @Nullable
    @NonNls
    public String getPreverifyPath() {
        return "bin/preverify";
    }

    @NonNls
    public abstract String getApplicationType();

    @NonNls
    @Nullable
    public abstract String getDescriptorOption();

    @Nullable
    @NonNls
    public abstract String getDeviceOption();

    @Nullable
    @NonNls
    public abstract String getRelativePathToEmulator();

    @Nullable
    public String[] getOTACommands() {
        return null;
    }

    @Nullable
    public String[] getOTACommands(String home) {
        return this.getOTACommands();
    }

    @Nullable
    @NonNls
    public String getPrefPath(String home) {
        return null;
    }

    @Nullable
    @NonNls
    public String getUtilPath(String home) {
        return null;
    }

    @Nullable
    @NonNls
    public String getPreverifyPath(String home) {
        return EmulatorType.toSystemDependentPath(home, this.getPreverifyPath());
    }

    @Nullable
    protected static String toSystemDependentPath(String home, @NonNls String path) {
        if (path == null) {
            return null;
        }
        return FileUtil.toSystemDependentName((String)(home + "/" + path));
    }

    @Nullable
    @NonNls
    public String getPathToEmulator(String home) {
        return EmulatorType.toSystemDependentPath(home, this.getRelativePathToEmulator());
    }

    @Nullable
    public String[] getApi(String homePath) {
        return null;
    }

    @Nullable
    public abstract String suggestName(String var1);

    public abstract boolean isValidHomeDirectory(String var1);

    @Nullable
    @NonNls
    public abstract String[] getAvailableSkins(String var1);

    public abstract J2MERunnableState getJ2MERunnableState(Executor var1, RunnerSettings var2, ConfigurationPerRunnerSettings var3, J2MERunConfiguration var4, Project var5, Sdk var6);
}

