/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.emulator;

import com.intellij.j2meplugin.emulator.EmulatorType;
import com.intellij.j2meplugin.emulator.midp.uei.UnifiedEmulatorType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Comparing;
import org.jetbrains.annotations.Nullable;

public class EmulatorUtil {
    private EmulatorUtil() {
    }

    @Nullable
    public static EmulatorType getEmulatorTypeByName(String name) {
        EmulatorType[] knownEmulatorTypes = (EmulatorType[])ApplicationManager.getApplication().getExtensions(EmulatorType.EMULATOR_TYPE_EXTENSION);
        for (int i = 0; knownEmulatorTypes != null && i < knownEmulatorTypes.length; ++i) {
            if (!Comparing.strEqual((String)knownEmulatorTypes[i].getName(), (String)name)) continue;
            return knownEmulatorTypes[i];
        }
        return null;
    }

    @Nullable
    public static EmulatorType getValidEmulatorType(String home) {
        EmulatorType[] knownEmulatorTypes;
        EmulatorType defaultEmulatorType = null;
        for (EmulatorType emulatorType : knownEmulatorTypes = (EmulatorType[])ApplicationManager.getApplication().getExtensions(EmulatorType.EMULATOR_TYPE_EXTENSION)) {
            if (emulatorType instanceof UnifiedEmulatorType) {
                defaultEmulatorType = emulatorType;
                continue;
            }
            if (!emulatorType.isValidHomeDirectory(home)) continue;
            return emulatorType;
        }
        return defaultEmulatorType != null && defaultEmulatorType.isValidHomeDirectory(home) ? defaultEmulatorType : null;
    }

    @Nullable
    public static String findFirstJavaSdk() {
        Sdk[] allJdks;
        ProjectJdkTable table = ProjectJdkTable.getInstance();
        for (Sdk jdk : allJdks = table.getAllJdks()) {
            if (!Comparing.equal((Object)jdk.getSdkType(), (Object)JavaSdk.getInstance())) continue;
            return jdk.getName();
        }
        return null;
    }
}

