/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.i18n;

import com.intellij.j2meplugin.i18n.ResourceBundlesBean;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import org.jdom.Element;

public class ResourceBeansContainer
implements PersistentStateComponent<Element> {
    private final ResourceBundlesBean myBean;
    private static final Logger LOG = Logger.getInstance((String)("#" + ResourceBeansContainer.class.getName()));

    public static ResourceBeansContainer getInstance(Project project) {
        return (ResourceBeansContainer)ServiceManager.getService((Project)project, ResourceBeansContainer.class);
    }

    public ResourceBeansContainer(Project project) {
        this.myBean = new ResourceBundlesBean(project);
    }

    public Element getState() {
        Element element = new Element("state");
        try {
            this.myBean.writeExternal(element);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return element;
    }

    public void loadState(Element state) {
        try {
            this.myBean.readExternal(state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public void registerResourceBundle(PsiClass aClass) {
        this.myBean.registerResourceBundle(aClass);
    }

    public PsiClass getResourceBundle() {
        return this.myBean.getResourceBundle();
    }
}

