/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.config;

import com.intellij.javaee.oss.jboss.config.JBossConfigProcessor;
import com.intellij.javaee.oss.jboss.server.JBossServerModel;
import com.intellij.javaee.oss.jboss.version.JBossVersion7Handler;
import com.intellij.javaee.oss.util.CachedConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.NotNull;

public class Jboss7DomainServersConfig
extends CachedConfig<JBossServerModel> {
    private static final Map<CachedConfig.Key, Jboss7DomainServersConfig> ourCache = new HashMap<CachedConfig.Key, Jboss7DomainServersConfig>();
    private static final CachedConfig.Factory<JBossServerModel, Jboss7DomainServersConfig> ourFactory = new CachedConfig.Factory<JBossServerModel, Jboss7DomainServersConfig>(){

        @NotNull
        public CachedConfig.Key createKey(JBossServerModel data) {
            CachedConfig.Key key = new CachedConfig.Key(new String[]{data.getHome(), data.getServerGroup()});
            if (key == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/jboss/config/Jboss7DomainServersConfig$1", "createKey"));
            }
            return key;
        }

        @NotNull
        public Jboss7DomainServersConfig createConfig(JBossServerModel data) {
            Jboss7DomainServersConfig jboss7DomainServersConfig = new Jboss7DomainServersConfig();
            if (jboss7DomainServersConfig == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/jboss/config/Jboss7DomainServersConfig$1", "createConfig"));
            }
            return jboss7DomainServersConfig;
        }
    };
    private List<String> myDomainServers;

    private static File getConfigFile(JBossServerModel data) {
        return JBossVersion7Handler.getDomainHostFile(data);
    }

    public static List<String> getDomainServers(JBossServerModel model) {
        Jboss7DomainServersConfig instance = (Jboss7DomainServersConfig)Jboss7DomainServersConfig.get(ourCache, ourFactory, (Object)((Object)model));
        return instance == null ? Collections.emptyList() : instance.myDomainServers;
    }

    protected long getStamp(JBossServerModel data) {
        return Jboss7DomainServersConfig.getStamp((File)Jboss7DomainServersConfig.getConfigFile(data));
    }

    protected void update(JBossServerModel data) {
        String xPath = "/ns:host/ns:servers/ns:server[not(@auto-start) or @auto-start='true'][@group='" + data.getServerGroup() + "']/@name";
        this.myDomainServers = (List)new JBossConfigProcessor<List<String>>(xPath, Collections.emptyList()){

            @Override
            protected List<String> process(XPath xpath, Document doc) throws JDOMException, IOException {
                ArrayList<String> result = new ArrayList<String>();
                for (Object node : xpath.selectNodes((Object)doc)) {
                    result.add(((Attribute)node).getValue());
                }
                return result;
            }
        }.get(Jboss7DomainServersConfig.getConfigFile(data));
    }
}

