/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.editor.security;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.javaee.model.xml.SecurityRole;
import com.intellij.javaee.module.view.common.attributes.JavaeeTreeTableView;
import com.intellij.javaee.oss.JavaeeBundle;
import com.intellij.javaee.oss.jboss.editor.security.JBossPrincipalNode;
import com.intellij.javaee.oss.jboss.editor.security.JBossSecurityRoleNode;
import com.intellij.javaee.oss.jboss.editor.security.JBossSecurityRoleUtil;
import com.intellij.javaee.oss.jboss.model.JBossSecurityRole;
import com.intellij.javaee.oss.jboss.model.JBossSecurityRoleHolder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.psi.PsiFile;
import com.intellij.util.xml.ui.DomCollectionControl;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

class JBossAddAction
extends AnAction {
    private final JBossSecurityRoleHolder holder;
    private final JavaeeTreeTableView view;

    JBossAddAction(JBossSecurityRoleHolder holder, JavaeeTreeTableView view) {
        super(JavaeeBundle.getText((String)"GenericAction.add", (Object[])new Object[0]), null, DomCollectionControl.ADD_ICON);
        this.holder = holder;
        this.view = view;
        this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(155, 0)), (JComponent)view.getTreeTableView());
    }

    public void actionPerformed(AnActionEvent event) {
        NodeDescriptor node = this.view.getSelectedDescriptor();
        if (node instanceof JBossPrincipalNode) {
            node = node.getParentDescriptor();
        }
        if (node instanceof JBossSecurityRoleNode) {
            final SecurityRole source = (SecurityRole)((JBossSecurityRoleNode)node).getElement();
            new WriteCommandAction<Object>(this.view.getProject(), new PsiFile[0]){

                protected void run(@NotNull Result<Object> result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javaee/oss/jboss/editor/security/JBossAddAction$1", "run"));
                    }
                    JBossSecurityRole role = JBossSecurityRoleUtil.findSecurityRole(JBossAddAction.this.holder, source);
                    if (role == null) {
                        role = JBossAddAction.this.holder.addSecurityRole();
                        role.getRoleName().setValue((Object)source);
                    }
                    role.addPrincipalName();
                }
            }.execute();
        }
    }

    public void update(AnActionEvent event) {
        NodeDescriptor node = this.view.getSelectedDescriptor();
        event.getPresentation().setEnabled(node instanceof JBossSecurityRoleNode || node instanceof JBossPrincipalNode);
    }
}

