/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.editor.security;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.javaee.model.xml.application.JavaeeApplication;
import com.intellij.javaee.model.xml.ejb.EjbJar;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.module.view.common.attributes.JavaeeTreeTableView;
import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.javaee.oss.jboss.JBossBundle;
import com.intellij.javaee.oss.jboss.editor.security.JBossAddAction;
import com.intellij.javaee.oss.jboss.editor.security.JBossPrincipalColumn;
import com.intellij.javaee.oss.jboss.editor.security.JBossRemoveAction;
import com.intellij.javaee.oss.jboss.editor.security.JBossSecurityRoleWrapper;
import com.intellij.javaee.oss.jboss.editor.security.JBossSecurityRolesNode;
import com.intellij.javaee.oss.jboss.model.JBossSecurityRoleHolder;
import com.intellij.javaee.oss.util.TableSourceAction;
import com.intellij.javaee.oss.util.TreeExpanderImpl;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.ColumnInfo;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBossSecurityRolesEditor
extends JavaeeTreeTableView {
    private final JBossSecurityRoleWrapper wrapper;
    private final JBossSecurityRoleHolder holder;

    public static JBossSecurityRolesEditor get(JavaeeApplication app, JBossSecurityRoleHolder holder) {
        return new JBossSecurityRolesEditor(JBossSecurityRoleWrapper.get(app), holder);
    }

    public static JBossSecurityRolesEditor get(EjbJar ejb, JBossSecurityRoleHolder holder) {
        return new JBossSecurityRolesEditor(JBossSecurityRoleWrapper.get(ejb), holder);
    }

    public static JBossSecurityRolesEditor get(WebApp web, JBossSecurityRoleHolder holder) {
        return new JBossSecurityRolesEditor(JBossSecurityRoleWrapper.get(web), holder);
    }

    JBossSecurityRolesEditor(JBossSecurityRoleWrapper wrapper, JBossSecurityRoleHolder holder) {
        super(holder.getManager().getProject(), (JavaeeNodeDescriptor)new JBossSecurityRolesNode(wrapper, holder));
        this.wrapper = wrapper;
        this.holder = holder;
        this.getComponent().setBorder((Border)IdeBorderFactory.createTitledBorder((String)JBossBundle.getText("JBossSecurityRolesEditor.title", new Object[0]), (boolean)true));
        this.init();
    }

    protected boolean isShowTree() {
        return !this.wrapper.getSecurityRoles().isEmpty();
    }

    @NotNull
    protected String getEmptyPaneText() {
        String string = JBossBundle.getText("JBossSecurityRolesEditor.empty", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/jboss/editor/security/JBossSecurityRolesEditor", "getEmptyPaneText"));
        }
        return string;
    }

    protected ColumnInfo<?, ?>[] createColumnInfos() {
        return new ColumnInfo[]{new JBossPrincipalColumn(this.getProject())};
    }

    @Nullable
    protected ActionGroup createToolbarActions() {
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)new JBossAddAction(this.holder, this));
        actions.add((AnAction)new JBossRemoveAction(this));
        actions.addSeparator();
        actions.add(CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)new TreeExpanderImpl((JTree)this.getTree()), (JComponent)this.getTree()));
        actions.add(CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)new TreeExpanderImpl((JTree)this.getTree()), (JComponent)this.getTree()));
        actions.addSeparator();
        actions.add((AnAction)new TableSourceAction((JTable)this.getTreeTableView()));
        return actions;
    }
}

