/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.server;

import com.intellij.javaee.oss.jboss.config.JBossBindingConfig;
import com.intellij.javaee.oss.jboss.config.JBossBindingSet;
import com.intellij.javaee.oss.jboss.server.JBossIntegration;
import com.intellij.javaee.oss.jboss.server.JBossLocalModel;
import com.intellij.javaee.oss.jboss.server.JBossOperatingModePanel;
import com.intellij.javaee.oss.jboss.version.JBossContributionsProvider;
import com.intellij.javaee.oss.jboss.version.JBossVersion6Handler;
import com.intellij.javaee.oss.jboss.version.JBossVersion7Handler;
import com.intellij.javaee.oss.jboss.version.JBossVersionContribution;
import com.intellij.javaee.oss.server.JavaeeRunSettingsEditor;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

class JBossLocalEditor
extends JavaeeRunSettingsEditor<JBossLocalModel> {
    private JPanel panel;
    private JComboBox server;
    private JTextField username;
    private JPasswordField password;
    private JComboBox myBindingSetComboBox;
    private JLabel myServerLabel;
    private JLabel myBindingSetLabel;
    private JBossOperatingModePanel myOperatingModePanel;
    private final JBossContributionsProvider<LocalEditorContribution> myContributionsProvider;
    private CommonModel myCommonModel;

    JBossLocalEditor() {
        super(JBossIntegration.getInstance());
        this.$$$setupUI$$$();
        this.server.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JBossLocalEditor.this.fireLogFilesChanged();
                JBossLocalEditor.this.updateBindingSets();
            }
        });
        this.myContributionsProvider = new JBossContributionsProvider<LocalEditorContribution>(LocalEditorContribution.class);
        this.myContributionsProvider.add(JBossVersion6Handler.ID, new LocalEditorContribution(){

            @Override
            public void resetEditorFrom(JBossLocalModel model) {
                JBossLocalEditor.this.setServerVisible(true);
                JBossLocalEditor.this.server.removeAllItems();
                File[] files = model.getServersDirectory().listFiles();
                if (files != null) {
                    for (File file : files) {
                        if (!file.isDirectory()) continue;
                        JBossLocalEditor.this.server.addItem(file.getName());
                    }
                }
                JBossLocalEditor.this.server.setSelectedItem(null);
                JBossLocalEditor.this.server.setSelectedItem(model.SERVER);
                JBossLocalEditor.this.myOperatingModePanel.setVisible(false);
            }
        });
        this.myContributionsProvider.add(JBossVersion7Handler.ID, new LocalEditorContribution(){

            @Override
            public void resetEditorFrom(JBossLocalModel model) {
                JBossLocalEditor.this.setServerVisible(false);
                JBossLocalEditor.this.myOperatingModePanel.resetEditorFrom(model);
                JBossLocalEditor.this.myOperatingModePanel.setVisible(true);
            }
        });
        this.myContributionsProvider.addDefault(new LocalEditorContribution(){

            @Override
            public void resetEditorFrom(JBossLocalModel model) {
                JBossLocalEditor.this.setServerVisible(false);
                JBossLocalEditor.this.myOperatingModePanel.setVisible(false);
            }
        });
    }

    private void setServerVisible(boolean visible) {
        this.server.setVisible(visible);
        this.myServerLabel.setVisible(visible);
        this.myBindingSetComboBox.setVisible(visible);
        this.myBindingSetLabel.setVisible(visible);
    }

    private void updateBindingSets() {
        JBossLocalModel model = new JBossLocalModel();
        model.setCommonModel(this.myCommonModel);
        this.applyEditorTo(model);
        this.resetBindingSets(model);
    }

    private void resetBindingSets(JBossLocalModel model) {
        this.myBindingSetComboBox.removeAllItems();
        List<JBossBindingSet> bindingSets = JBossBindingConfig.getBindingSets(model);
        boolean hasBindingSets = bindingSets != null;
        this.myBindingSetComboBox.setEnabled(hasBindingSets);
        if (hasBindingSets) {
            for (JBossBindingSet bindingSet : bindingSets) {
                this.myBindingSetComboBox.addItem(bindingSet.getName());
            }
            this.myBindingSetComboBox.setSelectedItem(null);
            this.myBindingSetComboBox.setSelectedItem(model.getCurrentBindingSetName());
        } else {
            String noBindingSet = "";
            this.myBindingSetComboBox.addItem(noBindingSet);
            this.myBindingSetComboBox.setSelectedItem(null);
            this.myBindingSetComboBox.setSelectedItem(noBindingSet);
        }
    }

    @NotNull
    protected JComponent getEditor() {
        JPanel jPanel = this.panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/jboss/server/JBossLocalEditor", "getEditor"));
        }
        return jPanel;
    }

    protected void resetEditorFrom(JBossLocalModel model) {
        this.myCommonModel = model.getCommonModel();
        model.getContribution(this.myContributionsProvider).resetEditorFrom(model);
        this.username.setText(model.USERNAME);
        this.password.setText(model.PASSWORD);
        this.resetBindingSets(model);
    }

    protected void applyEditorTo(JBossLocalModel model) {
        model.SERVER = (String)this.server.getSelectedItem();
        model.USERNAME = this.username.getText();
        model.PASSWORD = new String(this.password.getPassword());
        model.BINDING_SET_NAME = StringUtil.notNullize((String)((String)this.myBindingSetComboBox.getSelectedItem()));
        this.myOperatingModePanel.applyEditorTo(model);
    }

    private void createUIComponents() {
        this.myOperatingModePanel = new JBossOperatingModePanel(true);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPasswordField jPasswordField;
        JComboBox jComboBox;
        JLabel jLabel;
        JTextField jTextField;
        JComboBox jComboBox2;
        JLabel jLabel2;
        JPanel jPanel;
        this.createUIComponents();
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myServerLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("resources/jboss").getString("JBossLocalEditor.instance"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.server = jComboBox2 = new JComboBox();
        jPanel.add(jComboBox2, new GridConstraints(0, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("resources/javaee").getString("RunEditor.username"));
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.username = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(150, -1), null));
        this.myBindingSetLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("resources/jboss").getString("Form.JBossLocalEditor.bindingSet"));
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBindingSetComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(1, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("resources/javaee").getString("RunEditor.password"));
        jPanel.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.password = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(3, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JBossOperatingModePanel jBossOperatingModePanel = this.myOperatingModePanel;
        JComponent jComponent = jBossOperatingModePanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(4, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        jLabel2.setLabelFor(jComboBox2);
        jLabel3.setLabelFor(jTextField);
        jLabel.setLabelFor(jComboBox);
        jLabel4.setLabelFor(jPasswordField);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static interface LocalEditorContribution
    extends JBossVersionContribution {
        public void resetEditorFrom(JBossLocalModel var1);
    }
}

