/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.spring.data.util.QueryTree;
import com.intellij.spring.data.util.SpringDataUtil;
import com.intellij.spring.data.util.nodes.PropertyNode;
import com.intellij.spring.data.util.nodes.QueryNode;
import com.intellij.spring.data.util.nodes.SelectPropertyNode;
import com.intellij.spring.data.util.nodes.SimpleLeaf;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.HashSet;
import icons.SpringApiIcons;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringJpaCompletionContributor
extends CompletionContributor {
    public SpringJpaCompletionContributor() {
        PsiJavaElementPattern.Capture psiIdentifierCapture = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(PsiIdentifier.class).withParent(PsiField.class)).with((PatternCondition)new PatternCondition<PsiElement>("SpringDataRepository"){

            public boolean accepts(@NotNull PsiElement psiElement, ProcessingContext context) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/data/completion/SpringJpaCompletionContributor$1", "accepts"));
                }
                PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class);
                return psiClass != null && SpringDataUtil.isRepository(psiClass);
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)psiIdentifierCapture, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/data/completion/SpringJpaCompletionContributor$2", "addCompletions"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/data/completion/SpringJpaCompletionContributor$2", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/data/completion/SpringJpaCompletionContributor$2", "addCompletions"));
                }
                PersistentEntity persistenceEntity = SpringJpaCompletionContributor.this.getPersistenceEntity(parameters);
                if (persistenceEntity != null) {
                    result.addAllElements((Iterable)SpringJpaCompletionContributor.getCompletionVariants(persistenceEntity, SpringJpaCompletionContributor.this.getPsiFieldName(parameters), result.getPrefixMatcher()));
                    result.stopHere();
                }
            }
        });
    }

    @Nullable
    private PersistentEntity getPersistenceEntity(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "getPersistenceEntity"));
        }
        return SpringDataUtil.getPersistenceEntity((PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), PsiClass.class));
    }

    @Nullable
    private String getPsiFieldName(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "getPsiFieldName"));
        }
        PsiMember psiField = (PsiMember)parameters.getPosition().getParent();
        PsiMember originalElement = (PsiMember)PsiUtilBase.getOriginalElement((PsiElement)psiField, PsiMember.class);
        if (originalElement != null) {
            return originalElement.getName();
        }
        return null;
    }

    @NotNull
    private static Set<LookupElement> getCompletionVariants(@NotNull PersistentEntity persistenceEntity, @Nullable String fieldName, @NotNull PrefixMatcher matcher) {
        if (persistenceEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistenceEntity", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "getCompletionVariants"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "getCompletionVariants"));
        }
        if (fieldName == null) {
            Set<LookupElement> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "getCompletionVariants"));
            }
            return set;
        }
        HashSet set = new HashSet();
        String prefix = matcher.getPrefix();
        if (StringUtil.isEmptyOrSpaces((String)prefix)) {
            SpringJpaCompletionContributor.addSimpleCompletionVariants((Set<LookupElement>)set, persistenceEntity);
        } else {
            QueryTree queryTree = new QueryTree(fieldName);
            QueryTree prefixTree = new QueryTree(prefix);
            QueryNode[] nodes = queryTree.toLeavesArray();
            QueryNode[] subTreeNodes = prefixTree.toLeavesArray();
            if (subTreeNodes.length > 0 && nodes.length > 0) {
                int index = subTreeNodes.length - 1;
                boolean newTokenCompletion = nodes[index].getExpression().equals(subTreeNodes[index].getExpression());
                String prefixExpression = SpringJpaCompletionContributor.getPrefixExpression(nodes, index);
                String suffixExpression = SpringJpaCompletionContributor.getSuffixExpression(nodes, index);
                if (newTokenCompletion) {
                    if (nodes[index] instanceof SimpleLeaf && index + 1 < nodes.length) {
                        SpringJpaCompletionContributor.completeTokenVariants((Set<LookupElement>)set, nodes[index + 1], SpringJpaCompletionContributor.getPrefixExpression(nodes, index + 1), SpringJpaCompletionContributor.getSuffixExpression(nodes, index + 1), persistenceEntity);
                    } else {
                        SpringJpaCompletionContributor.completeNewTokenVariants((Set<LookupElement>)set, nodes[index], prefixExpression + nodes[index].getExpression(), suffixExpression, persistenceEntity);
                    }
                } else {
                    SpringJpaCompletionContributor.completeTokenVariants((Set<LookupElement>)set, nodes[index], prefixExpression, suffixExpression, persistenceEntity);
                }
            }
        }
        HashSet hashSet = set;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "getCompletionVariants"));
        }
        return hashSet;
    }

    private static void completeNewTokenVariants(@NotNull Set<LookupElement> set, @NotNull QueryNode lastNode, @NotNull String prefixExpression, @NotNull String suffixExpression, @NotNull PersistentEntity persistenceEntity) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "completeNewTokenVariants"));
        }
        if (lastNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastNode", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "completeNewTokenVariants"));
        }
        if (prefixExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixExpression", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "completeNewTokenVariants"));
        }
        if (suffixExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffixExpression", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "completeNewTokenVariants"));
        }
        if (persistenceEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistenceEntity", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "completeNewTokenVariants"));
        }
        if (lastNode instanceof SimpleLeaf) {
            SpringJpaCompletionContributor.addSimpleCompletionVariants(set, prefixExpression, suffixExpression, SpringJpaCompletionContributor.getProperties(persistenceEntity));
        } else if (lastNode instanceof PropertyNode) {
            if (StringUtil.isEmptyOrSpaces((String)lastNode.getExpression())) {
                SpringJpaCompletionContributor.addSimpleCompletionVariants(set, prefixExpression, suffixExpression, SpringJpaCompletionContributor.getProperties(persistenceEntity));
            } else {
                PropertyNode propertyNode = (PropertyNode)lastNode;
                if (propertyNode.isDefaultKeyword()) {
                    SpringJpaCompletionContributor.addSimpleCompletionVariants(set, prefixExpression, suffixExpression, propertyNode.getPropertyKeywords());
                }
                SpringJpaCompletionContributor.addChildrenPropertyVariants(set, prefixExpression, suffixExpression, persistenceEntity, propertyNode);
                if (suffixExpression.length() == 0 && lastNode instanceof SelectPropertyNode) {
                    SpringJpaCompletionContributor.addSimpleCompletionVariants(set, prefixExpression, suffixExpression, SpringJpaCompletionContributor.getOperations());
                }
            }
        }
    }

    private static void addChildrenPropertyVariants(@NotNull Set<LookupElement> set, @NotNull String prefixExpression, @NotNull String suffixExpression, @NotNull PersistentEntity persistenceEntity, PropertyNode propertyNode) {
        PersistentEntity entity;
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "addChildrenPropertyVariants"));
        }
        if (prefixExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixExpression", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "addChildrenPropertyVariants"));
        }
        if (suffixExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffixExpression", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "addChildrenPropertyVariants"));
        }
        if (persistenceEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistenceEntity", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "addChildrenPropertyVariants"));
        }
        PsiType psiType = SpringDataUtil.resolveJpaProperty(propertyNode.getPropertyName(), (PsiClass)persistenceEntity.getClazz().getValue());
        if (psiType instanceof PsiClassType && (entity = SpringDataUtil.getMappedPersistenceEntity(((PsiClassType)psiType).resolve())) != null) {
            for (PersistentAttribute field : entity.getObjectModelHelper().getAttributes()) {
                String name = field.getName().getStringValue();
                if (name == null) continue;
                String decapitalized = StringUtil.capitalize((String)name);
                SpringJpaCompletionContributor.addSimpleCompletionVariants(set, prefixExpression, propertyNode.getKeyword() + suffixExpression, Collections.singleton(decapitalized));
                SpringJpaCompletionContributor.addSimpleCompletionVariants(set, prefixExpression, propertyNode.getKeyword() + suffixExpression, Collections.singleton("_" + decapitalized));
            }
        }
    }

    private static void completeTokenVariants(@NotNull Set<LookupElement> set, @NotNull QueryNode node, @NotNull String prefixExpression, @NotNull String suffixExpression, @NotNull PersistentEntity persistenceEntity) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "completeTokenVariants"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "completeTokenVariants"));
        }
        if (prefixExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixExpression", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "completeTokenVariants"));
        }
        if (suffixExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffixExpression", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "completeTokenVariants"));
        }
        if (persistenceEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistenceEntity", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "completeTokenVariants"));
        }
        if (node instanceof PropertyNode) {
            Set<String> properties = SpringJpaCompletionContributor.getProperties(persistenceEntity);
            SpringJpaCompletionContributor.addSimpleCompletionVariants(set, prefixExpression, suffixExpression, properties);
            if (StringUtil.isNotEmpty((String)suffixExpression)) {
                SpringJpaCompletionContributor.addSimpleCompletionVariants(set, prefixExpression, "", properties);
            }
            for (String property : properties) {
                Set<String> propertyKeywords = ((PropertyNode)node).getPropertyKeywords();
                SpringJpaCompletionContributor.addSimpleCompletionVariants(set, prefixExpression + StringUtil.capitalize((String)property), suffixExpression, propertyKeywords);
                if (!StringUtil.isNotEmpty((String)suffixExpression)) continue;
                SpringJpaCompletionContributor.addSimpleCompletionVariants(set, prefixExpression + StringUtil.capitalize((String)property), "", propertyKeywords);
            }
            SpringJpaCompletionContributor.addChildrenPropertyVariants(set, prefixExpression + StringUtil.capitalize((String)((PropertyNode)node).getPropertyName()), suffixExpression, persistenceEntity, (PropertyNode)node);
        }
    }

    private static String getPrefixExpression(QueryNode[] nodes, int i) {
        StringBuffer sb = new StringBuffer();
        if (i < nodes.length) {
            for (int j = 0; j < i; ++j) {
                sb.append(nodes[j].getExpression());
            }
        }
        return sb.toString();
    }

    private static String getSuffixExpression(QueryNode[] nodes, int i) {
        StringBuffer sb = new StringBuffer();
        for (int j = i + 1; j < nodes.length; ++j) {
            sb.append(nodes[j].getExpression());
        }
        return sb.toString();
    }

    private static void addSimpleCompletionVariants(@NotNull Set<LookupElement> set, @NotNull String prefixExpression, @NotNull String suffixExpression, @NotNull Set<String> properties) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "addSimpleCompletionVariants"));
        }
        if (prefixExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixExpression", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "addSimpleCompletionVariants"));
        }
        if (suffixExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffixExpression", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "addSimpleCompletionVariants"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "addSimpleCompletionVariants"));
        }
        for (String property : properties) {
            set.add((LookupElement)SpringJpaCompletionContributor.createLookupElement(prefixExpression, StringUtil.capitalize((String)property), suffixExpression));
            if (StringUtil.isEmptyOrSpaces((String)suffixExpression)) continue;
            set.add((LookupElement)SpringJpaCompletionContributor.createLookupElement(prefixExpression, StringUtil.capitalize((String)property), suffixExpression));
        }
    }

    private static LookupElementBuilder createLookupElement(@NotNull String prefixExpression, @NotNull String property, @NotNull String suffixExpression) {
        if (prefixExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixExpression", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "createLookupElement"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "createLookupElement"));
        }
        if (suffixExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffixExpression", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "createLookupElement"));
        }
        String lookupText = prefixExpression + property + suffixExpression;
        return LookupElementBuilder.create((String)lookupText).withPresentableText(prefixExpression + property).bold().withTailText(StringUtil.isEmptyOrSpaces((String)suffixExpression) ? "..." : suffixExpression, true).withIcon(SpringApiIcons.Spring).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
            }
        });
    }

    private static void addSimpleCompletionVariants(@NotNull Set<LookupElement> elements, @NotNull PersistentEntity persistenceEntity) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "addSimpleCompletionVariants"));
        }
        if (persistenceEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistenceEntity", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "addSimpleCompletionVariants"));
        }
        Set<String> properties = SpringJpaCompletionContributor.getProperties(persistenceEntity);
        Set<String> methodPrefixes = SpringJpaCompletionContributor.getMethodPrefixes();
        for (String methodPrefix : methodPrefixes) {
            elements.add((LookupElement)SpringJpaCompletionContributor.createLookupElement("", methodPrefix, ""));
            for (String property : properties) {
                elements.add((LookupElement)SpringJpaCompletionContributor.createLookupElement(methodPrefix, StringUtil.capitalize((String)property), ""));
            }
        }
    }

    private static Set<String> getMethodPrefixes() {
        HashSet strings = new HashSet();
        strings.add((Object)"findBy");
        strings.add((Object)"findDistinctBy");
        strings.add((Object)"getBy");
        strings.add((Object)"getDistinctBy");
        strings.add((Object)"readBy");
        strings.add((Object)"readDistinctBy");
        return strings;
    }

    private static Set<String> getProperties(@NotNull PersistentEntity entity) {
        if (entity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entity", "com/intellij/spring/data/completion/SpringJpaCompletionContributor", "getProperties"));
        }
        HashSet strings = new HashSet();
        List attributes = entity.getObjectModelHelper().getAttributes();
        for (PersistentAttribute attribute : attributes) {
            String name = attribute.getName().getStringValue();
            if (!StringUtil.isNotEmpty((String)name)) continue;
            strings.add((Object)name);
        }
        return strings;
    }

    private static Set<String> getOperations() {
        HashSet strings = new HashSet();
        strings.add((Object)"And");
        strings.add((Object)"Or");
        strings.add((Object)"OrderBy");
        return strings;
    }
}

