/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.data.jam.SpringRepositoryDefinition;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDataUtil {
    public static final Pattern METHOD_TEMPLATE = Pattern.compile("^(find|read|get)(\\p{Upper}.*?)??By");

    public static boolean hasSpringDataSupport(Project project) {
        return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            boolean foundMarkerClass = JavaPsiFacade.getInstance((Project)project).findClass("org.springframework.data.repository.Repository", ProjectScope.getLibrariesScope((Project)project)) != null;
            return CachedValueProvider.Result.createSingleDependency((Object)foundMarkerClass, (Object)ProjectRootManager.getInstance((Project)project));
        });
    }

    public static boolean isQueryMethod(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/data/util/SpringDataUtil", "isQueryMethod"));
        }
        return METHOD_TEMPLATE.matcher(psiMethod.getName()).find();
    }

    public static boolean isRepository(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/data/util/SpringDataUtil", "isRepository"));
        }
        if (!psiClass.hasModifierProperty("public")) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.data.repository.Repository") || AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"org.springframework.data.repository.RepositoryDefinition", (boolean)true);
    }

    @NotNull
    public static List<SpringRepositoryDefinition> getRepositoryDefinitions(@NotNull GlobalSearchScope scope, @NotNull Project project) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/data/util/SpringDataUtil", "getRepositoryDefinitions"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/data/util/SpringDataUtil", "getRepositoryDefinitions"));
        }
        JamService service = JamService.getJamService((Project)project);
        List list = service.getJamClassElements(SpringRepositoryDefinition.META, "org.springframework.data.repository.RepositoryDefinition", scope);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/util/SpringDataUtil", "getRepositoryDefinitions"));
        }
        return list;
    }

    @Nullable
    public static PersistentEntity getPersistenceEntity(@Nullable PsiClass repositoryClass) {
        if (repositoryClass == null || !SpringDataUtil.isRepository(repositoryClass)) {
            return null;
        }
        Pair<PsiClass, ? extends PsiType> repositoryTypes = SpringDataUtil.substituteRepositoryTypes(repositoryClass);
        if (repositoryTypes != null) {
            return SpringDataUtil.getMappedPersistenceEntity(repositoryTypes);
        }
        return null;
    }

    @Nullable
    public static PersistentEntity getMappedPersistenceEntity(Pair<PsiClass, ? extends PsiType> repositoryTypes) {
        return SpringDataUtil.getMappedPersistenceEntity((PsiClass)repositoryTypes.getFirst());
    }

    @Nullable
    public static PersistentEntity getMappedPersistenceEntity(@Nullable PsiClass psiClass) {
        PersistentObject persistentObject;
        PersistenceClassRole[] roles = PersistenceCommonUtil.getPersistenceRoles((PsiClass)psiClass);
        if (roles.length != 0 && (persistentObject = roles[0].getPersistentObject()) instanceof PersistentEntity) {
            return (PersistentEntity)persistentObject;
        }
        return null;
    }

    @Nullable
    public static Pair<PsiClass, ? extends PsiType> substituteRepositoryTypes(@NotNull PsiClass repositoryClass) {
        if (repositoryClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryClass", "com/intellij/spring/data/util/SpringDataUtil", "substituteRepositoryTypes"));
        }
        Project project = repositoryClass.getProject();
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)repositoryClass, (String)"org.springframework.data.repository.RepositoryDefinition", (boolean)true)) {
            return SpringDataUtil.substituteRepositoryDefinitionTypes(repositoryClass);
        }
        PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)project).getElementFactory().createType(repositoryClass);
        PsiType psiType = PsiUtil.substituteTypeParameter((PsiType)psiClassType, (String)"org.springframework.data.repository.Repository", (int)0, (boolean)false);
        if (psiType instanceof PsiClassType) {
            PsiType idPsiType = PsiUtil.substituteTypeParameter((PsiType)psiClassType, (String)"org.springframework.data.repository.Repository", (int)1, (boolean)false);
            return Pair.create((Object)((PsiClassType)psiType).resolve(), (Object)idPsiType);
        }
        return null;
    }

    @Nullable
    private static Pair<PsiClass, ? extends PsiType> substituteRepositoryDefinitionTypes(@NotNull PsiClass repositoryClass) {
        if (repositoryClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryClass", "com/intellij/spring/data/util/SpringDataUtil", "substituteRepositoryDefinitionTypes"));
        }
        JamService service = JamService.getJamService((Project)repositoryClass.getProject());
        SpringRepositoryDefinition repositoryDefinition = (SpringRepositoryDefinition)service.getJamElement((PsiElement)repositoryClass, new JamMemberMeta[]{SpringRepositoryDefinition.META});
        if (repositoryDefinition != null) {
            PsiClass domainClass = repositoryDefinition.getDomainClass();
            if (domainClass == null) {
                return null;
            }
            PsiClass idClass = repositoryDefinition.getIdClass();
            return Pair.create((Object)domainClass, (Object)(idClass == null ? PsiType.NULL : PsiTypesUtil.getClassType((PsiClass)idClass)));
        }
        return null;
    }

    @Nullable
    public static PsiType resolveJpaProperty(@NotNull String propertyName, @Nullable PsiClass psiClass) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/spring/data/util/SpringDataUtil", "resolveJpaProperty"));
        }
        if (psiClass == null) {
            return null;
        }
        PersistentEntity persistenceEntity = SpringDataUtil.getMappedPersistenceEntity(psiClass);
        if (persistenceEntity != null) {
            return SpringDataUtil.resolveJpaProperty(propertyName, persistenceEntity);
        }
        return null;
    }

    @Nullable
    public static PsiType resolveJpaProperty(String propertyName, PersistentEntity persistenceEntity) {
        List attributes = persistenceEntity.getObjectModelHelper().getAttributes();
        for (PersistentAttribute attribute : attributes) {
            PsiType psiType = SpringDataUtil.resolveProperty(propertyName, attribute.getName().getStringValue(), attribute.getPsiType());
            if (psiType == null) continue;
            return psiType;
        }
        return null;
    }

    @Nullable
    private static PsiType resolveProperty(@Nullable String expression, @Nullable String propertyName, @Nullable PsiType psiType) {
        if (psiType == null || StringUtil.isEmptyOrSpaces((String)propertyName) || StringUtil.isEmptyOrSpaces((String)expression)) {
            return null;
        }
        if (expression.equals(propertyName)) {
            return psiType;
        }
        if (psiType instanceof PsiClassType) {
            String childPropertyExpression = SpringDataUtil.getChildPropertyExpression(expression, propertyName);
            PsiClass resolve = ((PsiClassType)psiType).resolve();
            if (resolve != null && !StringUtil.isEmptyOrSpaces((String)childPropertyExpression) && StringUtil.isCapitalized((String)childPropertyExpression)) {
                for (PsiField psiField : resolve.getAllFields()) {
                    PsiType resolvedType = SpringDataUtil.resolveProperty(StringUtil.decapitalize((String)childPropertyExpression), psiField.getName(), psiField.getType());
                    if (resolvedType == null) continue;
                    return resolvedType;
                }
            }
        }
        return null;
    }

    private static boolean hasNextProperty(@NotNull String expression, @NotNull String propertyName) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/spring/data/util/SpringDataUtil", "hasNextProperty"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/spring/data/util/SpringDataUtil", "hasNextProperty"));
        }
        return StringUtil.isCapitalized((String)SpringDataUtil.getChildPropertyExpression(expression, propertyName));
    }

    @Nullable
    public static String getChildPropertyExpression(@Nullable String expression, @Nullable String parentProperty) {
        if (expression == null || parentProperty == null) {
            return null;
        }
        if (expression.startsWith(parentProperty)) {
            String childExpression = expression.substring(parentProperty.length(), expression.length());
            if (childExpression.equals("_")) {
                return "";
            }
            if (childExpression.startsWith("_")) {
                return childExpression.substring(1, childExpression.length());
            }
            return childExpression;
        }
        return null;
    }
}

