/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc;

import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.ide.TypePresentationService;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.spring.web.mvc.jam.MVCPathVariable;
import com.intellij.spring.web.mvc.jam.RequestMapping;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.spring.web.mvc.jam.SpringMVCModelAttribute;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class SpringMvcRequestMappingDocumentationProvider
extends AbstractDocumentationProvider {
    static final String HTML_HEAD = "<html><head><style>.strike {text-decoration: line-through;}</style></head>";

    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        PsiClass containingClass;
        RequestMapping requestMapping = SpringMvcRequestMappingDocumentationProvider.getRequestMapping(element);
        if (requestMapping == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("<html>");
        SpringMvcRequestMappingDocumentationProvider.appendElementTypeURLs(sb, requestMapping);
        RequestMethod[] requestMethods = requestMapping.getMethods();
        if (requestMethods.length != 0) {
            sb.append(" ");
            sb.append(RequestMethod.getDisplay((RequestMethod[])requestMethods));
        }
        if ((containingClass = requestMapping.getPsiElement().getContainingClass()) != null) {
            sb.append("<br/>");
            sb.append(containingClass.getQualifiedName());
        }
        sb.append("</html>");
        return sb.toString();
    }

    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        RequestMapping requestMapping = SpringMvcRequestMappingDocumentationProvider.getRequestMapping(element);
        if (requestMapping == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(HTML_HEAD);
        SpringMvcRequestMappingDocumentationProvider.appendElementTypeURLs(sb, requestMapping);
        SpringMvcRequestMappingDocumentationProvider.addMethodLink(sb, requestMapping);
        SpringMvcRequestMappingDocumentationProvider.addHeadersParams(sb, requestMapping);
        SpringMvcRequestMappingDocumentationProvider.addConsumesProduces(sb, requestMapping);
        SpringMvcRequestMappingDocumentationProvider.addRequestMethod(sb, requestMapping);
        SpringMvcRequestMappingDocumentationProvider.addModelAttributes(sb, requestMapping);
        SpringMvcRequestMappingDocumentationProvider.addPathVariables(sb, requestMapping);
        sb.append("</html>");
        return sb.toString();
    }

    @Nullable
    private static RequestMapping getRequestMapping(PsiElement element) {
        Object modelObject = JamCommonUtil.getModelObject((PsiElement)element);
        if (!(modelObject instanceof RequestMapping)) {
            return null;
        }
        return (RequestMapping)modelObject;
    }

    private static void appendElementTypeURLs(StringBuilder sb, RequestMapping<?> requestMapping) {
        sb.append(TypePresentationService.getService().getTypeName(requestMapping));
        sb.append(" <b>");
        StringUtil.join(requestMapping.getUrls(), (String)", ", (StringBuilder)sb);
        sb.append("</b>");
    }

    private static void addHeadersParams(StringBuilder sb, RequestMapping<?> mapping) {
        List<String> params;
        List<String> headers = mapping.getHeaders();
        if (!headers.isEmpty()) {
            sb.append("Headers: ");
            StringUtil.join(headers, (String)", ", (StringBuilder)sb);
            SpringMvcRequestMappingDocumentationProvider.newLine(sb);
        }
        if (!(params = mapping.getParams()).isEmpty()) {
            sb.append("Params: ");
            StringUtil.join(params, (String)", ", (StringBuilder)sb);
            SpringMvcRequestMappingDocumentationProvider.newLine(sb);
        }
    }

    private static void addConsumesProduces(StringBuilder sb, RequestMapping<?> mapping) {
        List<String> produces;
        List<String> consumes = mapping.getConsumes();
        if (!consumes.isEmpty()) {
            sb.append("Consumes: ");
            Iterator<String> it = consumes.iterator();
            while (it.hasNext()) {
                String consume = it.next();
                if (StringUtil.startsWithChar((CharSequence)consume, (char)'!')) {
                    sb.append("<span class=\"strike\">").append(consume).append("</span>");
                } else {
                    sb.append(consume);
                }
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            SpringMvcRequestMappingDocumentationProvider.newLine(sb);
        }
        if (!(produces = mapping.getProduces()).isEmpty()) {
            sb.append("Produces: ");
            StringUtil.join(produces, (String)", ", (StringBuilder)sb);
            SpringMvcRequestMappingDocumentationProvider.newLine(sb);
        }
    }

    private static void addRequestMethod(StringBuilder sb, RequestMapping requestMapping) {
        RequestMethod[] requestMethods = requestMapping.getMethods();
        if (requestMethods.length != 0) {
            sb.append("Methods: ");
            sb.append(RequestMethod.getDisplay((RequestMethod[])requestMethods));
            SpringMvcRequestMappingDocumentationProvider.newLine(sb);
        }
    }

    private static void addModelAttributes(StringBuilder sb, RequestMapping<?> requestMapping) {
        List<SpringMVCModelAttribute> modelAttributes = requestMapping.getModelAttributes();
        if (!modelAttributes.isEmpty()) {
            SpringMvcRequestMappingDocumentationProvider.newLine(sb);
            sb.append("Model attributes: ");
            Iterator<SpringMVCModelAttribute> it = modelAttributes.iterator();
            while (it.hasNext()) {
                SpringMVCModelAttribute attribute = it.next();
                sb.append(attribute.getName());
                sb.append(":");
                JavaDocInfoGenerator.generateType((StringBuilder)sb, (PsiType)attribute.getType(), requestMapping.getPsiElement(), (boolean)true);
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
        }
    }

    private static void addPathVariables(StringBuilder sb, RequestMapping<?> mapping) {
        if (!(mapping instanceof RequestMapping.Method)) {
            return;
        }
        RequestMapping.Method methodMapping = (RequestMapping.Method)mapping;
        List<MVCPathVariable> pathVariables = methodMapping.getPathVariables();
        if (!pathVariables.isEmpty()) {
            SpringMvcRequestMappingDocumentationProvider.newLine(sb);
            sb.append("Path variables: ");
            Iterator<MVCPathVariable> it = pathVariables.iterator();
            while (it.hasNext()) {
                MVCPathVariable pathVariable = it.next();
                sb.append(pathVariable.getName());
                sb.append(":");
                JavaDocInfoGenerator.generateType((StringBuilder)sb, (PsiType)pathVariable.getType(), methodMapping.getPsiElement(), (boolean)true);
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
        }
    }

    private static void addMethodLink(StringBuilder sb, RequestMapping requestMapping) {
        if (requestMapping instanceof RequestMapping.Method) {
            Object requestMappingPsiElement = requestMapping.getPsiElement();
            String methodName = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)requestMappingPsiElement), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4103, (int)2);
            sb.append("<pre><a href=\"psi_element://");
            sb.append(JavaDocUtil.getReferenceText((Project)requestMappingPsiElement.getProject(), requestMappingPsiElement));
            sb.append("\">");
            sb.append(methodName);
            sb.append("</a></pre>");
            SpringMvcRequestMappingDocumentationProvider.newLine(sb);
        }
    }

    private static void newLine(StringBuilder sb) {
        sb.append("<br/>");
    }
}

