/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.jam;

import com.intellij.ide.presentation.Presentation;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamEnumAttributeElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamEnumAttributeMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiTarget;
import com.intellij.semantic.SemKey;
import com.intellij.spring.web.mvc.jam.MVCPathVariable;
import com.intellij.spring.web.mvc.jam.RequestMapping;
import com.intellij.spring.web.mvc.jam.RequestMappingUtil;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.spring.web.mvc.jam.SpringMVCModelAttribute;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="@RequestMapping", icon="SpringMvcIcons.RequestMapping")
public abstract class SpringRequestMapping<T extends PsiMember>
implements RequestMapping<T> {
    private static final JamStringAttributeMeta.Collection<String> VALUE_META = JamAttributeMeta.collectionString((String)"value");
    private static final JamStringAttributeMeta.Collection<String> PATH_META = JamAttributeMeta.collectionString((String)"path");
    private static final JamEnumAttributeMeta.Collection<RequestMethod> METHOD_META = new JamEnumAttributeMeta.Collection("method", RequestMethod.class);
    private static final JamStringAttributeMeta.Collection<String> CONSUMES_META = JamAttributeMeta.collectionString((String)"consumes", (JamConverter)new RequestMappingMimetypeConverter());
    private static final JamStringAttributeMeta.Collection<String> PRODUCES_META = JamAttributeMeta.collectionString((String)"produces", (JamConverter)new RequestMappingMimetypeConverter());
    private static final JamStringAttributeMeta.Collection<String> PARAMS_META = JamAttributeMeta.collectionString((String)"params");
    private static final JamStringAttributeMeta.Collection<String> HEADERS_META = JamAttributeMeta.collectionString((String)"headers");
    private static final JamAnnotationMeta REQUEST_MAPPING_ANNO_META = new JamAnnotationMeta("org.springframework.web.bind.annotation.RequestMapping").addAttribute(VALUE_META).addAttribute(PATH_META).addAttribute(METHOD_META).addAttribute(CONSUMES_META).addAttribute(PRODUCES_META).addAttribute(PARAMS_META).addAttribute(HEADERS_META);
    private final Function<JamStringAttributeElement<String>, PsiTarget> myMapping = url -> url.getPsiLiteral() == null ? null : new JamPomTarget((JamElement)this, url);

    private List<String> mapToStringList(JamStringAttributeMeta.Collection<String> attributeMeta) {
        return SpringRequestMapping.mapToStringList((List)REQUEST_MAPPING_ANNO_META.getAttribute(this.getPsiElement(), attributeMeta));
    }

    static List<String> mapToStringList(List<JamStringAttributeElement<String>> stringAttributeElements) {
        return ContainerUtil.mapNotNull(stringAttributeElements, JamStringAttributeElement::getStringValue);
    }

    @Override
    public List<JamStringAttributeElement<String>> getMappingUrls() {
        PsiElementRef psiElementRef = PsiElementRef.real(this.getPsiElement());
        List valueElements = (List)REQUEST_MAPPING_ANNO_META.getAttribute(psiElementRef, VALUE_META);
        if (!valueElements.isEmpty()) {
            return valueElements;
        }
        return (List)REQUEST_MAPPING_ANNO_META.getAttribute(psiElementRef, PATH_META);
    }

    @Override
    public RequestMethod[] getMethods() {
        List methods = ContainerUtil.mapNotNull((Collection)((Collection)REQUEST_MAPPING_ANNO_META.getAttribute(this.getPsiElement(), METHOD_META)), JamEnumAttributeElement::getValue);
        return methods.toArray(new RequestMethod[methods.size()]);
    }

    @Override
    public List<String> getUrls() {
        return SpringRequestMapping.mapToStringList(this.getMappingUrls());
    }

    @Override
    public List<String> getConsumes() {
        return this.mapToStringList(CONSUMES_META);
    }

    @Override
    public List<String> getProduces() {
        return this.mapToStringList(PRODUCES_META);
    }

    @Override
    public List<String> getParams() {
        return this.mapToStringList(PARAMS_META);
    }

    @Override
    public List<String> getHeaders() {
        return this.mapToStringList(HEADERS_META);
    }

    protected List<PsiTarget> getPomTargets() {
        return ContainerUtil.mapNotNull(this.getMappingUrls(), this.myMapping);
    }

    static /* synthetic */ JamAnnotationMeta access$100() {
        return REQUEST_MAPPING_ANNO_META;
    }

    private static class RequestMappingMimetypeConverter
    extends JamConverter<String> {
        private static String[] DEFAULT_MIME_TYPES = new String[]{"application/json", "text/html", "text/plain"};

        private RequestMappingMimetypeConverter() {
        }

        @Nullable
        public String fromString(@Nullable String s, JamStringAttributeElement<String> context) {
            return s;
        }

        @NotNull
        public PsiReference[] createReferences(JamStringAttributeElement<String> context) {
            PsiLiteral psiLiteral = context.getPsiLiteral();
            if (psiLiteral == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/jam/SpringRequestMapping$RequestMappingMimetypeConverter", "createReferences"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase.Immediate<PsiElement>((PsiElement)psiLiteral, (PsiElement)psiLiteral){

                @NotNull
                public Object[] getVariants() {
                    Object[] objectArray = DEFAULT_MIME_TYPES;
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/jam/SpringRequestMapping$RequestMappingMimetypeConverter$1", "getVariants"));
                    }
                    return objectArray;
                }
            }};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/jam/SpringRequestMapping$RequestMappingMimetypeConverter", "createReferences"));
            }
            return psiReferenceArray;
        }

        static {
            Arrays.sort(DEFAULT_MIME_TYPES);
        }
    }

    public static abstract class MethodMapping
    extends SpringRequestMapping<PsiMethod>
    implements RequestMapping.Method {
        private static final SemKey<MethodMapping> JAM_KEY = RequestMapping.METHOD_JAM_KEY.subKey("SpringMethodMapping", new SemKey[0]);
        static final JamMethodMeta<MethodMapping> META = new JamMethodMeta(null, MethodMapping.class, JAM_KEY).addAnnotation(SpringRequestMapping.access$100()).addChildrenQuery(MODEL_ATTRIBUTE_PARAMETERS_QUERY).addChildrenQuery(PATH_VARIABLE_PARAMETERS_QUERY).addPomTargetProducer((methodMapping, pomTargetConsumer) -> {
            for (PsiTarget target : methodMapping.getPomTargets()) {
                pomTargetConsumer.consume((Object)target);
            }
        });

        @Override
        public List<SpringMVCModelAttribute> getModelAttributes() {
            return MODEL_ATTRIBUTE_PARAMETERS_QUERY.findChildren(PsiElementRef.real(this.getPsiElement()));
        }

        @Override
        public List<MVCPathVariable> getPathVariables() {
            return PATH_VARIABLE_PARAMETERS_QUERY.findChildren(PsiElementRef.real(this.getPsiElement()));
        }

        @Override
        public RequestMethod[] getMethods() {
            return RequestMappingUtil.getAllRequestMethods(this);
        }

        @Override
        public RequestMethod[] getLocalMethods() {
            return super.getMethods();
        }

        @Override
        @Nullable
        public RequestMapping<PsiClass> getClassLevelMapping() {
            return RequestMappingUtil.getClassLevelMapping(this);
        }
    }

    public static abstract class ClassMapping
    extends SpringRequestMapping<PsiClass> {
        private static final SemKey<ClassMapping> JAM_KEY = RequestMapping.CLASS_JAM_KEY.subKey("SpringClassMapping", new SemKey[0]);
        static final JamClassMeta<ClassMapping> META = new JamClassMeta(null, ClassMapping.class, JAM_KEY).addAnnotation(SpringRequestMapping.access$100()).addChildrenQuery(MODEL_ATTRIBUTE_METHODS_QUERY).addPomTargetProducer((classMapping, pomTargetConsumer) -> {
            for (PsiTarget target : classMapping.getPomTargets()) {
                pomTargetConsumer.consume((Object)target);
            }
        });

        @Override
        public List<SpringMVCModelAttribute> getModelAttributes() {
            return MODEL_ATTRIBUTE_METHODS_QUERY.findChildren(PsiElementRef.real(this.getPsiElement()));
        }
    }
}

