/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.jam.testing;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.BeansSpringModel;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringImplicitBean;
import com.intellij.spring.model.jam.testContexts.ContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringTestingImplicitContextsProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringTestingMvcContextProvider
extends SpringTestingImplicitContextsProvider {
    @NotNull
    public Collection<CommonSpringModel> getModels(final Module module, @NotNull ContextConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/spring/web/mvc/jam/testing/SpringTestingMvcContextProvider", "getModels"));
        }
        List models = ContainerUtil.newSmartList();
        final GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)true);
        if (SpringTestingMvcContextProvider.isAnnotated((ContextConfiguration)configuration, (Module)module, (String)"org.springframework.test.context.web.WebAppConfiguration")) {
            models.add(new BeansSpringModel(module, (NotNullLazyValue)new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

                @NotNull
                protected Collection<? extends SpringBeanPointer> compute() {
                    SpringImplicitBean context = SpringImplicitBean.create((String)"MVC Testing Beans", (PsiClass)JavaPsiFacade.getInstance((Project)module.getProject()).findClass("org.springframework.mock.web.MockServletContext", searchScope), (String)"mockServletContext");
                    Collection<Object> collection = context != null ? Collections.singleton(BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)context)) : Collections.emptyList();
                    if (collection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/jam/testing/SpringTestingMvcContextProvider$1", "compute"));
                    }
                    return collection;
                }
            }));
        }
        List list = models;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/jam/testing/SpringTestingMvcContextProvider", "getModels"));
        }
        return list;
    }
}

