/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.model;

import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.model.SpringMVCModelImpl;
import com.intellij.spring.web.mvc.model.SpringMVCModelService;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringMVCModelServiceImpl
extends SpringMVCModelService {
    private static final Key<SpringMVCModel> KEY = Key.create((String)"spring mvc model");

    public SpringMVCModel getModel(PsiElement element) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return null;
        }
        SpringFacet springFacet = SpringFacet.getInstance((Module)module);
        if (springFacet == null) {
            return null;
        }
        WebFacet webFacet = WebUtil.getWebFacet((PsiElement)element);
        return webFacet == null ? null : this.getModel(webFacet, springFacet);
    }

    public SpringMVCModel getModel(@NotNull WebFacet facet, @NotNull SpringFacet springFacet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/spring/web/mvc/model/SpringMVCModelServiceImpl", "getModel"));
        }
        if (springFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springFacet", "com/intellij/spring/web/mvc/model/SpringMVCModelServiceImpl", "getModel"));
        }
        return SpringMVCModelServiceImpl.get(facet, springFacet);
    }

    private static SpringMVCModel get(WebFacet webFacet, SpringFacet springFacet) {
        Project project = webFacet.getModule().getProject();
        CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)webFacet.getModule(), () -> {
            SpringFileSetService.getInstance().getModelProviderSets(springFacet);
            return CachedValueProvider.Result.create((Object)"SpringMVCModelDummy", (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        return (SpringMVCModel)webFacet.getUserData(KEY);
    }

    public void clear(WebFacet webFacet) {
        webFacet.putUserData(KEY, null);
    }

    public void store(WebFacet webFacet, List<SpringFileSet> fileSets) {
        SpringMVCModelImpl springMVCModel = new SpringMVCModelImpl(webFacet, fileSets);
        webFacet.putUserData(KEY, (Object)springMVCModel);
    }
}

