/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.taglib;

import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.JSLanguageInjector;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.position.NamespaceFilter;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringJsInjector
implements MultiHostInjector {
    private static final NamespaceFilter NAMESPACE_FILTER = new NamespaceFilter(new String[]{"http://www.springframework.org/tags/form"});

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        PsiElement parent;
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/web/mvc/taglib/SpringJsInjector", "getLanguagesToInject"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/spring/web/mvc/taglib/SpringJsInjector", "getLanguagesToInject"));
        }
        FileType fileType = host.getContainingFile().getFileType();
        if (fileType != StdFileTypes.JSP && fileType != StdFileTypes.JSPX) {
            return;
        }
        if (host instanceof XmlAttributeValue && (parent = host.getParent()) instanceof XmlAttribute) {
            XmlAttribute xmlAttribute = (XmlAttribute)parent;
            String name = xmlAttribute.getName();
            if (!StringUtil.startsWith((CharSequence)name, (CharSequence)"on")) {
                return;
            }
            XmlTag tag = xmlAttribute.getParent();
            if (NAMESPACE_FILTER.isAcceptable((Object)tag, null)) {
                JSLanguageInjector.injectJSIntoAttributeValue((MultiHostRegistrar)registrar, (XmlAttributeValue)((XmlAttributeValue)host), (boolean)false);
            }
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(XmlAttributeValue.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/taglib/SpringJsInjector", "elementsToInjectIn"));
        }
        return list;
    }
}

