/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.taglib;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.XmlTagPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.jsp.el.ELContextProvider;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.spring.el.SpringELLanguage;
import com.intellij.spring.web.mvc.taglib.SpringElInJspContextProvider;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringTaglibELInjector
implements MultiHostInjector {
    private static final SpringELLanguage SPRING_EL_LANGUAGE = SpringELLanguage.INSTANCE;
    private static final ElementPattern<XmlAttributeValue> PATTERN = XmlPatterns.xmlAttributeValue().withLocalName(new String[]{"expression"}).withSuperParent(2, (ElementPattern)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withLocalName("eval")).withNamespace("http://www.springframework.org/tags"));

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/web/mvc/taglib/SpringTaglibELInjector", "getLanguagesToInject"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/web/mvc/taglib/SpringTaglibELInjector", "getLanguagesToInject"));
        }
        FileType type = context.getContainingFile().getFileType();
        if (type != StdFileTypes.JSP && type != StdFileTypes.JSPX) {
            return;
        }
        if (!PATTERN.accepts((Object)context)) {
            return;
        }
        int length = context.getTextLength();
        if (length < 2) {
            return;
        }
        registrar.startInjecting((Language)SPRING_EL_LANGUAGE).addPlace(null, null, (PsiLanguageInjectionHost)context, new TextRange(1, length - 1)).doneInjecting();
        context.putUserData(ELContextProvider.ourContextProviderKey, (Object)new SpringElInJspContextProvider(context));
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<XmlAttributeValue>> list = Collections.singletonList(XmlAttributeValue.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/taglib/SpringTaglibELInjector", "elementsToInjectIn"));
        }
        return list;
    }
}

