/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.views;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.spring.web.mvc.views.SpringMVCViewReferenceProvider;
import com.intellij.spring.web.mvc.views.ViewReference;
import com.intellij.util.SmartList;
import org.jetbrains.annotations.NotNull;

public class SpringMVCViewInspection
extends BaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/web/mvc/views/SpringMVCViewInspection", "buildVisitor"));
        }
        PsiFile file = holder.getFile();
        if (!JamCommonUtil.isPlainJavaFile((PsiElement)file)) {
            PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/SpringMVCViewInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitLiteralExpression(PsiLiteralExpression expression) {
                if (!SpringMVCViewReferenceProvider.VIEW_PATTERN.accepts((Object)expression)) {
                    return;
                }
                FileReferenceSet activeSet = null;
                SmartList problems = new SmartList();
                PsiReference[] references = expression.getReferences();
                for (PsiReference reference : references) {
                    if (reference.resolve() != null) {
                        if (reference instanceof ViewReference) {
                            return;
                        }
                        if (!(reference instanceof FileReference)) continue;
                        if (((FileReference)reference).isLast()) {
                            return;
                        }
                        activeSet = ((FileReference)reference).getFileReferenceSet();
                        continue;
                    }
                    if (activeSet == null && reference instanceof FileReference && (references.length == 1 || !((FileReference)reference).isLast())) {
                        activeSet = ((FileReference)reference).getFileReferenceSet();
                    }
                    problems.add(reference);
                }
                for (PsiReference reference : problems) {
                    if (reference.isSoft()) continue;
                    if (reference instanceof FileReference) {
                        if (activeSet == null || activeSet != ((FileReference)reference).getFileReferenceSet()) continue;
                        holder.registerProblem(reference);
                        continue;
                    }
                    if (activeSet != null) continue;
                    holder.registerProblem(reference);
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/SpringMVCViewInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @NotNull
    public String getShortName() {
        if ("SpringMVCViewInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/SpringMVCViewInspection", "getShortName"));
        }
        return "SpringMVCViewInspection";
    }
}

