/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.views;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.web.mvc.views.BeanNameViewResolverFactory;
import com.intellij.spring.web.mvc.views.ResourceBundleViewResolverFactory;
import com.intellij.spring.web.mvc.views.UrlBasedViewResolver;
import com.intellij.spring.web.mvc.views.UrlBasedViewResolverFactory;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolverFactory;
import com.intellij.spring.web.mvc.views.ViewResolverRegistry;
import com.intellij.spring.web.mvc.views.XmlViewResolverFactory;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class ViewResolverRegistryImpl
extends ViewResolverRegistry {
    private static final NotNullLazyValue<ViewResolverFactory[]> ourFactories = new NotNullLazyValue<ViewResolverFactory[]>(){

        @NotNull
        protected ViewResolverFactory[] compute() {
            Object[] builtinFactories = new ViewResolverFactory[]{new UrlBasedViewResolverFactory(), new BeanNameViewResolverFactory(), new XmlViewResolverFactory(), new ResourceBundleViewResolverFactory()};
            ViewResolverFactory[] viewResolverFactoryArray = (ViewResolverFactory[])ArrayUtil.mergeArrays((Object[])Extensions.getExtensions((ExtensionPointName)ViewResolverFactory.EP_NAME), (Object[])builtinFactories);
            if (viewResolverFactoryArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/ViewResolverRegistryImpl$1", "compute"));
            }
            return viewResolverFactoryArray;
        }
    };

    public ViewResolver createURLBasedViewResolver(String ID, CommonSpringBean bean) {
        UrlBasedViewResolver urlBasedViewResolver = new UrlBasedViewResolver(bean);
        urlBasedViewResolver.setID(ID);
        return urlBasedViewResolver;
    }

    public ViewResolver createURLBasedViewResolver(String ID, String prefix, String suffix) {
        UrlBasedViewResolver urlBasedViewResolver = new UrlBasedViewResolver(prefix, suffix);
        urlBasedViewResolver.setID(ID);
        return urlBasedViewResolver;
    }

    public ViewResolverFactory[] getAllFactories() {
        return (ViewResolverFactory[])ourFactories.getValue();
    }
}

