/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import icons.JetgroovyIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.highlighter.GroovyEditorHighlighter;

public class GroovyFileType
extends LanguageFileType {
    public static final List<FileType> GROOVY_FILE_TYPES = new ArrayList<FileType>();
    @NotNull
    public static final GroovyFileType GROOVY_FILE_TYPE = new GroovyFileType();
    @NonNls
    public static final String DEFAULT_EXTENSION = "groovy";

    private GroovyFileType() {
        super((Language)GroovyLanguage.INSTANCE);
        FileTypeEditorHighlighterProviders.INSTANCE.addExplicitExtension((Object)this, (Object)new EditorHighlighterProvider(){

            public EditorHighlighter getEditorHighlighter(@Nullable Project project, @NotNull FileType fileType, @Nullable VirtualFile virtualFile, @NotNull EditorColorsScheme colors) {
                if (fileType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "org/jetbrains/plugins/groovy/GroovyFileType$1", "getEditorHighlighter"));
                }
                if (colors == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colors", "org/jetbrains/plugins/groovy/GroovyFileType$1", "getEditorHighlighter"));
                }
                return new GroovyEditorHighlighter(colors);
            }
        });
        GROOVY_FILE_TYPES.add((FileType)this);
    }

    @NotNull
    public static FileType[] getGroovyEnabledFileTypes() {
        FileType[] fileTypeArray = GROOVY_FILE_TYPES.toArray(new FileType[GROOVY_FILE_TYPES.size()]);
        if (fileTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/GroovyFileType", "getGroovyEnabledFileTypes"));
        }
        return fileTypeArray;
    }

    @NotNull
    @NonNls
    public String getName() {
        if ("Groovy" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/GroovyFileType", "getName"));
        }
        return "Groovy";
    }

    @NonNls
    @NotNull
    public String getDescription() {
        if ("Groovy Files" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/GroovyFileType", "getDescription"));
        }
        return "Groovy Files";
    }

    @NotNull
    @NonNls
    public String getDefaultExtension() {
        if (DEFAULT_EXTENSION == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/GroovyFileType", "getDefaultExtension"));
        }
        return DEFAULT_EXTENSION;
    }

    public Icon getIcon() {
        return JetgroovyIcons.Groovy.Groovy_16x16;
    }

    public boolean isJVMDebuggingSupported() {
        return true;
    }
}

